/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.common;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.messages.CommonsRuntimeException;
import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.platform.commons.messages.MessageUtil;
import com.ibm.bi.search.common.SearchMessageKeys;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public class SearchException
extends CommonsRuntimeException {
    private static final long serialVersionUID = 9108354034952058966L;
    private static final String ERRORS_NAME = "errors";
    private static final String CODE_NAME = "code";
    private static final String MESSAGE_NAME = "message";
    private static final String LEVEL_NAME = "level";
    private static final String ERROR_LEVEL_NAME = "error";
    private static final String DESCRIPTION_NAME = "description";
    private static final String MORE_INFO_NAME = "more_info";
    private static final int DEFAULT_ERROR = 500;
    private final int responseStatus;

    public SearchException(IMessageKey.Param0 msgKey) {
        this(msgKey, 500);
    }

    public SearchException(IMessageKey.Param0 msgKey, int responseStatus) {
        this(new Message(msgKey), responseStatus);
    }

    public SearchException(Message message, int responseStatus) {
        this(message, responseStatus, null);
    }

    public SearchException(IMessageKey.Param1 msgKey, String msgParam) {
        this(msgKey, msgParam, 500);
    }

    public SearchException(IMessageKey.Param1 msgKey, String msgParam, int responseStatus) {
        this(new Message(msgKey, (Object)msgParam), responseStatus);
    }

    public SearchException(IMessageKey.Param1 msgKey, String msgParam, int responseStatus, Exception cause) {
        this(new Message(msgKey, (Object)msgParam), responseStatus, cause);
    }

    public SearchException(IMessageKey.Param2 msgKey, String msgParam1, String msgParam2) {
        this(msgKey, msgParam1, msgParam2, 500);
    }

    public SearchException(IMessageKey.Param2 msgKey, String msgParam1, String msgParam2, int responseStatus) {
        this(new Message(msgKey, (Object)msgParam1, (Object)msgParam2), responseStatus);
    }

    public SearchException(IMessageKey.Param3 msgKey, String msgParam1, String msgParam2, String msgParam3) {
        this(msgKey, msgParam1, msgParam2, msgParam3, 500);
    }

    public SearchException(IMessageKey.Param3 msgKey, String msgParam1, String msgParam2, String msgParam3, int responseStatus) {
        this(new Message(msgKey, (Object)msgParam1, (Object)msgParam2, (Object)msgParam3), responseStatus);
    }

    public SearchException(IMessageKey.Param0 msgKey, Exception cause) {
        this(msgKey, 500, cause);
    }

    public SearchException(IMessageKey.Param0 msgKey, int responseStatus, Exception cause) {
        this(new Message(msgKey), responseStatus, cause);
    }

    public SearchException(Message message, int responseStatus, Exception cause) {
        super((Throwable)cause, message);
        this.responseStatus = responseStatus;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public Response buildResponse() {
        return Response.status((int)this.getResponseStatus()).entity((Object)this.buildError().toString()).build();
    }

    private JsonObject buildError() {
        JsonArray errors = new JsonArray();
        Object exception = this;
        do {
            String message = SearchException.getLocalizedMessage((Throwable)exception);
            String[] splitErrorMessage = SearchException.splitMessage((Throwable)exception, message);
            JsonObject error = SearchException.buildError(splitErrorMessage);
            errors.add((Object)error);
        } while ((exception = ((Throwable)exception).getCause()) != null);
        return SearchException.toJson(errors);
    }

    private static String getLocalizedMessage(Throwable exception) {
        String message = exception.getLocalizedMessage();
        if (StringUtils.isEmpty((String)message)) {
            message = exception.toString();
        }
        return message;
    }

    private static String[] splitMessage(Throwable exception, String message) {
        String[] splitErrorMessage = new String[]{"", message};
        if (exception instanceof SearchException) {
            splitErrorMessage = MessageUtil.splitErrorCodeAndMessage((String)message);
        }
        return splitErrorMessage;
    }

    private static JsonObject buildError(String[] splitErrorMessage) {
        JsonObject error = new JsonObject();
        error.put(CODE_NAME, (Object)splitErrorMessage[0]);
        error.put(MESSAGE_NAME, (Object)splitErrorMessage[1]);
        error.put(LEVEL_NAME, (Object)ERROR_LEVEL_NAME);
        error.put(DESCRIPTION_NAME, (Object)"");
        error.put(MORE_INFO_NAME, (Object)"");
        return error;
    }

    private static JsonObject toJson(JsonArray errors) {
        JsonObject error = new JsonObject();
        error.put(ERRORS_NAME, (Object)errors);
        return error;
    }

    public static SearchException wrap(Exception e, String message, Object ... args) {
        return SearchException.wrap(e, 500, String.format(message, args), new Object[0]);
    }

    public static SearchException wrap(Exception e, int responseStatus, String message, Object ... args) {
        return new SearchException(SearchMessageKeys.INTERNAL_ERROR, String.format(message, args), responseStatus, e);
    }

    public static SearchException wrapIfNeeded(Exception e) {
        if (e instanceof SearchException) {
            return (SearchException)((Object)e);
        }
        return SearchException.wrap(e, e.getLocalizedMessage(), new Object[0]);
    }
}

