/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.extract;

import com.ibm.bi.search.extract.ExtractUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractExtractData {
    public static final String OUTPUT_FOLDER = "./target/unittests/output";
    protected static final int MAX_READ_BYTE_SIZE = 8192;
    protected InputStream fileInput;
    protected String extractFileName;
    protected static final Charset FILE_CHARSET = StandardCharsets.UTF_16;
    private long uncompressedFileSize;
    protected static final long MAX_FILE_SIZE = 0xA00000L;

    protected AbstractExtractData(String dataFileName, boolean compressed) throws IOException {
        this.uncompressedFileSize = this.calculateUncompressedSize(dataFileName, compressed);
        this.extractFileName = dataFileName;
        this.fileInput = compressed ? new GZIPInputStream(new FileInputStream(dataFileName)) : new FileInputStream(dataFileName);
    }

    private long calculateUncompressedSize(String dataFileName, boolean compressed) throws IOException {
        this.extractFileName = dataFileName;
        if (compressed) {
            return AbstractExtractData.getUncompressedFileSize(dataFileName);
        }
        return AbstractExtractData.getFileSize(dataFileName);
    }

    /*
     * Exception decompiling
     */
    private static long getUncompressedFileSize(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long getStreamSize(InputStream stream) throws IOException {
        int length;
        long size = 0L;
        byte[] buffer = new byte[8192];
        while ((length = stream.read(buffer, 0, 8192)) != -1) {
            size += (long)length;
        }
        return size;
    }

    private static long getFileSize(String fileName) throws IOException {
        try (FileInputStream in = new FileInputStream(fileName);){
            long l = in.getChannel().size();
            return l;
        }
    }

    Set<String> tokenizeString(String strLine, String splitTag) {
        HashSet<String> contentSet = new HashSet<String>();
        for (String token : strLine.split(splitTag)) {
            AbstractExtractData.addTokenToContentSet(token, contentSet);
        }
        return contentSet;
    }

    private static void addTokenToContentSet(String token, Set<String> contentSet) {
        String trimmedToken = StringUtils.trim((String)token);
        if (ExtractUtils.isQualifyingToken(trimmedToken)) {
            contentSet.add(trimmedToken);
        }
    }

    protected String convertSetToString(Set<String> contentSet) {
        StringBuilder toString = new StringBuilder();
        for (String tok : contentSet) {
            if (toString.length() != 0) {
                toString.append(" ");
            }
            toString.append(tok);
        }
        return toString.toString();
    }

    public abstract String analyzeData() throws IOException;

    public long getUncompressedFileSize() {
        return this.uncompressedFileSize;
    }
}

