/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.extract;

import com.ibm.bi.search.background.UpdateOutputController;
import com.ibm.bi.search.extract.ExternalObjectStore;
import com.ibm.bi.search.util.SearchConfig;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final long EXECUTION_PERIOD = 5L;
    private final UpdateOutputController updateOutputController;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, r -> {
        Thread t = new Thread(r);
        t.setPriority(1);
        return t;
    });

    public BackgroundTask() {
        this(new UpdateOutputController());
    }

    protected BackgroundTask(UpdateOutputController uOController) {
        this.updateOutputController = uOController;
    }

    public void start() {
        LOG.info("Starting the background task for ancestors and EOS at the interval of 5 minutes.");
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                this.execute();
            }
            catch (Exception ex) {
                LOG.error("Error occurred while processing the extraction task", (Throwable)ex);
            }
        }, 0L, 5L, TimeUnit.MINUTES);
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    private void execute() {
        if (BackgroundTask.isEOSIndexingEnabled()) {
            LOG.debug("Executing EOS output indexing background task.");
            this.updateOutputController.processDocuments();
        }
    }

    private static boolean isEOSIndexingEnabled() {
        return SearchConfig.isEOSIndexingEnabled() && ExternalObjectStore.isEOSEnabled();
    }
}

