/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.extract;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.search.util.FileURIUtils;
import com.ibm.bi.search.util.SearchConfig;
import java.io.File;
import java.io.IOException;

public class ExternalObjectStore {
    private static final String CM_EOS_FILESTORE_URI = "CM.eos.fileStoreURI.";
    private static final String WIN_URI = "winURI";
    private static final String UNIX_URI = "unixURI";
    private static String externalObjectStoreURI = null;
    private static String externalObjectStoreLocation = null;
    private static boolean checkEOS = false;

    private ExternalObjectStore() {
    }

    public static boolean isEOSEnabled() {
        if (!checkEOS) {
            return ExternalObjectStore.resolveURIDirectory() != null;
        }
        return externalObjectStoreLocation != null;
    }

    public static String resolveURIDirectory() {
        if (externalObjectStoreLocation == null) {
            String eosParameter = CM_EOS_FILESTORE_URI;
            eosParameter = SearchConfig.isRunningWindows() ? eosParameter + WIN_URI : eosParameter + UNIX_URI;
            if (externalObjectStoreURI == null) {
                externalObjectStoreURI = ConfigurationPropertyFactory.getInstance().getStringProperty(eosParameter, "").get();
            }
            externalObjectStoreLocation = FileURIUtils.resolveURIDirectory(externalObjectStoreURI);
        }
        return externalObjectStoreLocation;
    }

    public static void setObjectStoreForTesting(String pathname) throws IOException {
        externalObjectStoreURI = ExternalObjectStore.buildFileURI(pathname);
        externalObjectStoreLocation = null;
        checkEOS = false;
    }

    private static String buildFileURI(String pathname) throws IOException {
        File savedFile = new File(pathname);
        String absolute = savedFile.getCanonicalPath();
        String resolved = absolute.replace('\\', '/');
        return "file:///" + resolved;
    }

    static void reset() {
        externalObjectStoreURI = null;
        externalObjectStoreLocation = null;
        checkEOS = false;
    }
}

