/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.extract;

import com.ibm.bi.search.extract.AbstractExtractData;
import com.ibm.bi.search.extract.ExtractUtils;
import com.ibm.bi.search.util.SearchConfig;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractExcelData
extends AbstractExtractData {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private long sizeLimit;
    Set<String> tokenSet = new HashSet<String>();

    ExtractExcelData(String fileName, boolean compressed) throws IOException {
        super(fileName, compressed);
        this.sizeLimit = (long)SearchConfig.getEosExcelOutputSizeLimitMB().intValue() * 0x100000L;
    }

    public int getTokenCount() {
        return this.tokenSet.size();
    }

    public String getTokens() {
        return this.tokenSet.toString();
    }

    @Override
    public String analyzeData() throws IOException {
        String[] tokens;
        LOG.trace("\t extracting Excel file {} of size {}", (Object)this.extractFileName, (Object)this.getUncompressedFileSize());
        if (this.getUncompressedFileSize() > this.sizeLimit) {
            LOG.warn("\t extract Excel file failed: {} size over limit of {}", (Object)this.extractFileName, (Object)this.sizeLimit);
            this.fileInput.close();
            return null;
        }
        this.tokenSet.clear();
        String tokenString = this.extractXSSFText();
        if (tokenString == null) {
            return null;
        }
        for (String token : tokens = tokenString.split("[\\t\\n]")) {
            if (!ExtractUtils.isQualifyingToken(token)) continue;
            this.tokenSet.add(token);
        }
        return this.tokenSet.toString();
    }

    /*
     * Exception decompiling
     */
    private String extractXSSFText() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

