/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.extract;

import com.ibm.bi.search.extract.AbstractExtractData;
import com.ibm.bi.search.extract.ExternalObjectStore;
import com.ibm.bi.search.extract.ExtractCSVData;
import com.ibm.bi.search.extract.ExtractExcelData;
import com.ibm.bi.search.extract.ExtractHTMLData;
import com.ibm.bi.search.extract.ExtractPDFData;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavedOutput {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String BACK_SLASH = "//";
    private static final int FIRST_IMPORTANT = 1;
    private static final int SECOND_IMPORTANT = 2;
    private static final String COMPRESSED = "compressed";
    private static final String CONTENT_TYPE = "contentType";
    private static final String DATA = ".data";
    private String fileFormat;
    private boolean isCompressed;
    private String storeID;
    private String relativePath;

    public SavedOutput(String storeID) {
        this.storeID = storeID;
        this.buildRelativePathFromStoreID();
    }

    public FileType getType() {
        FileType dataFileType = FileType.UNSUPORTED;
        if (this.fileFormat.contains("text/html")) {
            dataFileType = FileType.HTML;
        } else if (this.fileFormat.contains("application/pdf")) {
            dataFileType = FileType.PDF;
        } else if (this.fileFormat.contains("application/vnd.ms-excel")) {
            dataFileType = FileType.CSV;
        } else if (this.fileFormat.contains("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            dataFileType = FileType.EXCEL;
        }
        return dataFileType;
    }

    public String analyzeOutputDataFile() {
        String outputDataFileName = null;
        try {
            if (!this.readMetaDataFile()) {
                return null;
            }
            FileType dataFileType = this.getType();
            outputDataFileName = this.buildOutPutFilePath(DATA);
            if (outputDataFileName == null) {
                return null;
            }
            AbstractExtractData extractData = this.extractKeywords(outputDataFileName, dataFileType);
            return extractData != null ? extractData.analyzeData() : null;
        }
        catch (IOException e) {
            LOG.trace("\t analyzeData file: " + outputDataFileName + " failed", (Throwable)e);
            return null;
        }
    }

    private AbstractExtractData extractKeywords(String outputDataFileName, FileType dataFileType) throws IOException {
        switch (dataFileType) {
            case CSV: {
                return new ExtractCSVData(outputDataFileName, this.isCompressed);
            }
            case HTML: {
                return new ExtractHTMLData(outputDataFileName, this.isCompressed);
            }
            case PDF: {
                return new ExtractPDFData(outputDataFileName, this.isCompressed);
            }
            case EXCEL: {
                return new ExtractExcelData(outputDataFileName, this.isCompressed);
            }
        }
        LOG.debug("\t analyzeData skipped file: {} of unsupported type: {}", (Object)outputDataFileName, (Object)this.fileFormat);
        return null;
    }

    private String buildRelativePathFromStoreID() {
        if (this.storeID == null) {
            return null;
        }
        StringBuilder dirString = new StringBuilder();
        dirString.append(BACK_SLASH);
        dirString.append(this.storeID.substring(1, 3));
        dirString.append(BACK_SLASH);
        dirString.append(this.storeID.charAt(3));
        this.relativePath = dirString.toString();
        return this.relativePath;
    }

    private String buildOutPutFilePath(String fileExtention) {
        if (this.storeID == null) {
            return null;
        }
        String externalObjectStoreLocation = ExternalObjectStore.resolveURIDirectory();
        if (externalObjectStoreLocation == null) {
            return null;
        }
        StringBuilder outputFileDirecotryPath = new StringBuilder();
        outputFileDirecotryPath.append(externalObjectStoreLocation);
        outputFileDirecotryPath.append(this.relativePath);
        outputFileDirecotryPath.append(BACK_SLASH);
        outputFileDirecotryPath.append(this.storeID);
        outputFileDirecotryPath.append(fileExtention);
        return outputFileDirecotryPath.toString();
    }

    private boolean readMetaDataFile() throws IOException {
        String fileDir = this.buildOutPutFilePath(".meta");
        if (fileDir == null) {
            return false;
        }
        LOG.trace("\t Read the meta data file: {}", (Object)fileDir);
        FileInputStream fis = new FileInputStream(fileDir);
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));){
            String line;
            String compressedString = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(CONTENT_TYPE)) {
                    this.fileFormat = line.substring(CONTENT_TYPE.length() + 1);
                    continue;
                }
                if (!line.startsWith(COMPRESSED)) continue;
                compressedString = line.substring(COMPRESSED.length() + 1);
            }
            this.isCompressed = Boolean.valueOf(compressedString);
            LOG.trace("\t meta data file: format: {}, compress: {}", (Object)this.fileFormat, (Object)this.isCompressed);
        }
        return true;
    }

    public static enum FileType {
        HTML,
        CSV,
        PDF,
        EXCEL,
        UNSUPORTED;

    }
}

