/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.collections;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.handlers.collections.SolrHandlerInitExecutor;
import com.ibm.bi.search.handlers.common.QueryResult;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.indexing.solr.SolrHandler;
import com.ibm.bi.search.indexing.solr.SolrHandlerFactory;
import java.util.List;

public class CollectionsController {
    private final SolrHandlerFactory solrFactory;
    private final SolrHandlerInitExecutor initExecutor;

    public CollectionsController() {
        this(new SolrHandlerFactory(), new SolrHandlerInitExecutor());
    }

    protected CollectionsController(SolrHandlerFactory solrFactory, SolrHandlerInitExecutor initExecutor) {
        this.solrFactory = solrFactory;
        this.initExecutor = initExecutor;
    }

    public void initialize() {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            this.initExecutor.executeInitialize(solrHandler);
        }
    }

    public void createCollection(JsonObject schema) {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            solrHandler.createCore(schema);
        }
    }

    public List<String> getCollectionsList() {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            List<String> list = solrHandler.getCores();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject getCollection(String collectionName) {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            JsonObject jsonObject = solrHandler.getCore(collectionName);
            return jsonObject;
        }
    }

    public void deleteCollection(String collectionName) {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            solrHandler.deleteCore(collectionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(String collectionName, JsonObject document) {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            solrHandler.addDocument(collectionName, document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocuments(String collectionName, JsonArray documents) {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            solrHandler.addDocuments(collectionName, documents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDocument(String collectionName, String documentId) {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            solrHandler.deleteDocument(collectionName, documentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDocumentsByQuery(String collectionName, String q) {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            solrHandler.deleteDocumentsByQuery(collectionName, q);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult query(String collectionName, SolrQueryParameters qp) {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            QueryResult queryResult = solrHandler.query(collectionName, qp);
            return queryResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult query(String collectionName, SolrQueryParameters qp, List<String> locales) {
        try (SolrHandler solrHandler = this.solrFactory.createSolrHandler();){
            QueryResult queryResult = solrHandler.query(collectionName, qp, locales);
            return queryResult;
        }
    }
}

