/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.collections;

import com.ibm.bi.search.handlers.collections.tasks.AddBatchDocumentsTask;
import com.ibm.bi.search.handlers.collections.tasks.AddDocumentTask;
import com.ibm.bi.search.handlers.collections.tasks.CreateCollectionTask;
import com.ibm.bi.search.handlers.collections.tasks.DeleteCollectionTask;
import com.ibm.bi.search.handlers.collections.tasks.DeleteDocumentTask;
import com.ibm.bi.search.handlers.collections.tasks.DeleteDocumentsByQueryTask;
import com.ibm.bi.search.handlers.collections.tasks.GetCollectionTask;
import com.ibm.bi.search.handlers.collections.tasks.GetCollectionsTask;
import com.ibm.bi.search.handlers.common.BaseHandler;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.invoke.MethodHandles;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/collections")
@Api(value="/collections", description="Solr collection management")
public class CollectionsHandler
extends BaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Context
    private HttpServletRequest httpRequest;
    @Context
    private Request rsRequest;

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create new search collection.", notes="Create new search collection in Solr. If the index already exists, return an error.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=500, message="Internal error")})
    public Response createCollection(@ApiParam(name="schema", value="The JSON representation describing the new collection.", required=true) String schema) {
        this.logRequest(this.httpServletRequest, this.uriInfo, schema);
        return this.callTask(new CreateCollectionTask((BaseHandler)this, schema));
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get information about all cores/collections.", notes="Get information about cores/collections.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public Response getCollections() {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        return this.callTask(new GetCollectionsTask(this));
    }

    @GET
    @Path(value="{collectionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get information about a core/collection.", notes="Get information about a core/collection. If the core/collection does not exist an error is returned.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=500, message="Internal error")})
    public Response getCollection(@PathParam(value="collectionId") @ApiParam(name="collectionId", value="The collection the operation is performed in.", required=true) String collectionId) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        return this.callTask(new GetCollectionTask((BaseHandler)this, collectionId));
    }

    @DELETE
    @Path(value="{collectionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the specified collection.", notes="Remove all collection documents and delete the collection.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=500, message="Internal error")})
    public Response deleteCollection(@PathParam(value="collectionId") @ApiParam(name="collectionId", value="The collection the operation is performed in.", required=true) String collectionId) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        return this.callTask(new DeleteCollectionTask((BaseHandler)this, collectionId));
    }

    @POST
    @Path(value="{collectionId}/documents")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add new document to a collection.", notes="Create new collection document that matches defined collection schema.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=500, message="Internal error")})
    public Response addDocument(@PathParam(value="collectionId") @ApiParam(name="collectionId", value="The collection the operation is performed in.", required=true) String collectionId, @ApiParam(name="documents", value="Json of the document wish to be added", required=true) String documentBody) {
        this.logRequest(this.httpServletRequest, this.uriInfo, documentBody);
        return this.callTask(new AddDocumentTask((BaseHandler)this, collectionId, documentBody));
    }

    @PUT
    @Path(value="{collectionId}/documents")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add new document(s) to a collection.", notes="Create new collection document that matches defined collection schema.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=500, message="Internal error")})
    public Response addBatchDocuments(@PathParam(value="collectionId") @ApiParam(name="collectionId", value="The collection the operation is performed in.", required=true) String collectionId, @ApiParam(name="documents", value="Json of the documents wish to be added", required=true) String documents) {
        this.logRequest(this.httpServletRequest, this.uriInfo, documents);
        return this.callTask(new AddBatchDocumentsTask((BaseHandler)this, collectionId, documents));
    }

    @DELETE
    @Path(value="{collectionId}/documents")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete documents from a collection by Solr query.", notes="Deletes the documents returned by the specified Solr query.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=500, message="Internal error")})
    public Response deleteDocumentsByQuery(@PathParam(value="collectionId") @ApiParam(name="collectionId", value="The collection the operation is performed in.", required=true) String collectionId, @QueryParam(value="query") @ApiParam(name="query", value="Specify a search query by using the official Solr query syntax.", required=true) String query) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        return this.callTask(new DeleteDocumentsByQueryTask((BaseHandler)this, collectionId, query));
    }

    @DELETE
    @Path(value="{collectionId}/documents/{documentId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a document from a collection.", notes="Deletes the document specified by the object id", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=500, message="Internal error")})
    public Response deleteDocument(@PathParam(value="collectionId") @ApiParam(name="collectionId", value="The collection the operation is performed in.", required=true) String collectionId, @PathParam(value="documentId") @ApiParam(name="documentId", value="The id of the document to remove.", required=true) String documentId) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        return this.callTask(new DeleteDocumentTask((BaseHandler)this, collectionId, documentId));
    }
}

