/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.collections;

import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.indexing.solr.SolrHandler;
import com.ibm.bi.search.util.SearchConfig;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrHandlerInitExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int initTimeoutWait = SearchConfig.getInitTimeoutMilliseconds();
    private final int cleanTimeoutWait = SearchConfig.getCleanTimeoutMilliseconds();

    public void executeInitialize(SolrHandler solrHandler) {
        long initStart = this.logInitStart();
        ExecutorService executor = Executors.newCachedThreadPool();
        Future<?> initialize = executor.submit(solrHandler::initialize);
        try {
            this.runFutureWithTimeout(initialize, this.initTimeoutWait);
            this.logInitFinish(initStart);
        }
        catch (TimeoutException timeout) {
            LOG.info("SolrHandler initialization timed out, rebuilding indices and trying again...");
            initialize.cancel(true);
            this.executeCleanInitialize(solrHandler);
        }
        catch (ExecutionException e) {
            LOG.info("SolrHandler failed due to an Execution Exception, rebuilding indices and trying again...", (Throwable)e);
            initialize.cancel(true);
            this.executeCleanInitialize(solrHandler);
        }
        catch (InterruptedException e) {
            SolrHandlerInitExecutor.restoreInterruptedState();
            throw SearchException.wrap((Exception)e, "Interrupted during initialization", new Object[0]);
        }
    }

    private long logInitStart() {
        LOG.info("SolrHandler Initialization starting...");
        return System.currentTimeMillis();
    }

    private void logInitFinish(long startTime) {
        long endTime = System.currentTimeMillis() - startTime;
        LOG.info("Initialization successfully completed in {} ms", (Object)endTime);
    }

    private void runFutureWithTimeout(Future<?> future, int timeout) throws InterruptedException, ExecutionException, TimeoutException {
        future.get(timeout, TimeUnit.MILLISECONDS);
    }

    private void executeCleanInitialize(SolrHandler solrHandler) {
        long cleanStartTime = this.logCleanInitStart();
        ExecutorService executor = Executors.newCachedThreadPool();
        Future<?> cleanInitialize = executor.submit(solrHandler::cleanInitialize);
        try {
            this.runFutureWithTimeout(cleanInitialize, this.cleanTimeoutWait);
            this.logCleanInitFinish(cleanStartTime);
        }
        catch (TimeoutException e) {
            cleanInitialize.cancel(true);
            throw SearchException.wrap((Exception)e, "SolrHandler initialization timed out after rebuilding indices", new Object[0]);
        }
        catch (ExecutionException e) {
            cleanInitialize.cancel(true);
            throw SearchException.wrap((Exception)e, "SolrHandler initialization failed after rebuilding indices due to an Execution Exception.", new Object[0]);
        }
        catch (InterruptedException e) {
            SolrHandlerInitExecutor.restoreInterruptedState();
            throw SearchException.wrap((Exception)e, "Initialization interrupted during second attempt", new Object[0]);
        }
    }

    private long logCleanInitStart() {
        return System.currentTimeMillis();
    }

    private void logCleanInitFinish(long startTime) {
        long endTime = System.currentTimeMillis() - startTime;
        LOG.info("Clean initialization successfully completed in {} ms", (Object)endTime);
    }

    private static void restoreInterruptedState() {
        Thread.currentThread().interrupt();
    }
}

