/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.collections.tasks;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.async.Task;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.constants.SchemaProperties;
import com.ibm.bi.search.handlers.collections.tasks.CollectionsTask;
import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.common.JSONBuilder;
import javax.ws.rs.core.Response;

public class AddBatchDocumentsTask
extends CollectionsTask {
    private final String collectionId;
    private final String documents;

    public AddBatchDocumentsTask(BaseHandler handler, String collectionId, String documents) {
        super(handler, Task.Type.READ_WRITE);
        this.collectionId = collectionId;
        this.documents = documents;
    }

    @Override
    protected Response executeTask() {
        JsonArray documentsJson = this.parseDocuments();
        this.getController().addDocuments(this.collectionId, documentsJson);
        return this.buildOkResponse();
    }

    private JsonArray parseDocuments() {
        JsonObject bodyJson = JSONBuilder.parseJsonObject(this.documents);
        Object documentsJson = bodyJson.get(SchemaProperties.DOCUMENTS.toString());
        if (!(documentsJson instanceof JsonArray)) {
            throw new SearchException(SearchMessageKeys.INVALID_DATA_FORMAT);
        }
        return (JsonArray)documentsJson;
    }
}

