/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.collections.tasks;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.async.Task;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.handlers.collections.tasks.CollectionsTask;
import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.common.JSONBuilder;
import javax.ws.rs.core.Response;

public class AddDocumentTask
extends CollectionsTask {
    private final String collectionId;
    private final String document;

    public AddDocumentTask(BaseHandler handler, String collectionId, String document) {
        super(handler, Task.Type.READ_WRITE);
        this.collectionId = collectionId;
        this.document = document;
    }

    @Override
    protected Response executeTask() {
        JsonObject documentJson = JSONBuilder.parseJsonObject(this.document);
        this.getController().addDocument(this.collectionId, documentJson);
        return this.buildResponse(documentJson);
    }

    @Override
    protected Response buildResponse(JsonObject json) {
        String documentId = json.getString(FieldNames.ID.toString());
        String location = String.format("/collections/%s/documents/%s", this.collectionId, documentId);
        return this.buildResponse(Response.ok().status(201).header("Location", (Object)location));
    }
}

