/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.collections.tasks;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.async.Task;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.handlers.collections.tasks.CollectionsTask;
import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.common.JSONBuilder;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class CreateCollectionTask
extends CollectionsTask {
    private final String schema;

    public CreateCollectionTask(BaseHandler handler, String schema) {
        super(handler, Task.Type.READ_WRITE);
        this.schema = schema;
    }

    @Override
    protected Response executeTask() {
        JsonObject schemaJson = JSONBuilder.parseJsonObject(this.schema);
        this.getController().createCollection(schemaJson);
        return this.buildResponse(schemaJson);
    }

    @Override
    protected Response buildResponse(JsonObject schemaJson) {
        String collectionId = schemaJson.getString(FieldNames.ID.toString());
        String location = UriBuilder.fromPath((String)"/collections").path(collectionId).build(new Object[0]).toString();
        return this.buildResponse(Response.ok().status(201).header("Location", (Object)location));
    }
}

