/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.common;

import com.ibm.bi.platform.commons.shared.BIResource;
import com.ibm.bi.platform.commons.shared.UserPreferences;
import com.ibm.bi.search.async.SearchExecutor;
import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.common.RestLogger;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.common.TrustedServiceIdentity;
import com.ibm.bi.search.handlers.common.BaseTask;
import com.ibm.bi.search.util.RESTHandlerUtil;
import com.ibm.bi.search.util.RESTHelper;
import com.ibm.bi.search.util.RequestContext;
import com.ibm.bi.search.util.SearchConfig;
import com.ibm.bi.search.util.TrustTokenAuthenticator;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHandler
extends BIResource {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String TRUSTED_SERVICE_ID_HEADER = "X-CA-Authorization";
    private static final HttpServletRequest NO_REQUEST_OVERRIDE = null;
    private TrustTokenAuthenticator trustTokenAuthenticator;
    @Context
    protected Request request;
    protected RESTHelper restHelper;
    private RestLogger restLogger;
    private static final SearchExecutor DEFAULT_EXECUTOR = new SearchExecutor();
    private final SearchExecutor executor;

    public BaseHandler() {
        this(new RESTHelper());
    }

    protected BaseHandler(RESTHelper restHelper) {
        this(restHelper, NO_REQUEST_OVERRIDE, DEFAULT_EXECUTOR);
    }

    protected BaseHandler(RESTHelper restHelper, HttpServletRequest requestOverride, SearchExecutor executor) {
        this(restHelper, requestOverride, new TrustTokenAuthenticator(), executor);
    }

    protected BaseHandler(RESTHelper restHelper, HttpServletRequest requestOverride, TrustTokenAuthenticator tokenAuthenticator, SearchExecutor executor) {
        this.restHelper = restHelper;
        this.executor = executor;
        this.restLogger = new RestLogger(this.getLog());
        if (requestOverride != NO_REQUEST_OVERRIDE) {
            this.httpServletRequest = requestOverride;
        }
        this.trustTokenAuthenticator = tokenAuthenticator;
    }

    protected Logger getLog() {
        return LOG;
    }

    private void saveShowHiddenObjects() {
        Boolean showHiddenObj = this.getUserPreferences().getBoolean("showHiddenObjects");
        if (showHiddenObj != null) {
            RequestContext.setShowHiddenObjects(showHiddenObj);
        }
        boolean canUseShowHiddenObjects = this.restHelper.getUserCapability(this.httpServletRequest, "canUseShowHiddenObjectsPreference");
        RequestContext.setCanUseShowHiddenObjectsPreference(canUseShowHiddenObjects);
    }

    protected UserPreferences getUserPreferences() {
        UserPreferences testUserPrefs = this.restHelper.getTestUserPreferences();
        if (testUserPrefs != null) {
            return testUserPrefs;
        }
        return super.getUserPreferences();
    }

    private void saveUserIdentity() {
        Identity identity = this.getUserIdentity();
        if (identity == null) {
            throw new SearchException(SearchMessageKeys.NOT_PRIVILEGED_USER_ERROR, 401);
        }
        RequestContext.setCurrentIdentity(identity);
    }

    protected void saveRequestContext() {
        RequestContext.setHttpRequest(this.httpServletRequest);
        if (this.isTrustedRequest()) {
            BaseHandler.saveTrustedRequestContext();
        } else {
            this.saveShowHiddenObjects();
            this.saveUserIdentity();
        }
    }

    private static void saveTrustedRequestContext() {
        RequestContext.setShowHiddenObjects(Boolean.TRUE);
        RequestContext.setCanUseShowHiddenObjectsPreference(Boolean.TRUE);
        RequestContext.setCurrentIdentity(new TrustedServiceIdentity());
    }

    protected Response getCachedResponse(Date lastModified) {
        return this.restHelper.checkRequestPreconditions(this.request, lastModified);
    }

    protected void validateRequestForTrustedOrSysAdmin() {
        if (!this.isValidRequest()) {
            throw new SearchException(SearchMessageKeys.NOT_PRIVILEGED_USER_ERROR, 401, null);
        }
    }

    private boolean isValidRequest() {
        return RESTHandlerUtil.isIntegrationTest() || this.isTrustedRequest() || this.isSysAdmin();
    }

    protected boolean isSysAdmin() {
        Identity identity = this.getUserIdentity();
        return identity != null && identity.isSystemAdmin();
    }

    protected Identity getUserIdentity() {
        return this.restHelper.getUserIdentity(this.httpServletRequest);
    }

    protected boolean isTrustedRequest() {
        String token = this.httpServletRequest.getHeader(TRUSTED_SERVICE_ID_HEADER);
        return token != null && this.trustTokenAuthenticator.isTrustTokenValid(token);
    }

    protected void logRequest(HttpServletRequest httpServletRequest, UriInfo uriInfo) {
        this.restLogger.logSearchRequest(httpServletRequest, uriInfo);
    }

    protected void logRequest(HttpServletRequest httpServletRequest, UriInfo uriInfo, String payload) {
        this.restLogger.logSearchRequest(httpServletRequest, uriInfo, payload);
    }

    protected void logResponse(Response response) {
        this.restLogger.logSearchResponse(response);
    }

    public String buildBaseURL() {
        return super.buildBaseURL();
    }

    protected Response callTask(BaseTask task) {
        try {
            return SearchConfig.areThreadPoolsEnabled() ? this.executor.invoke(task) : task.call();
        }
        catch (Exception e) {
            return task.buildErrorResponse(e);
        }
    }
}

