/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.common;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.SearchStatus;
import com.ibm.bi.search.async.Task;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.handlers.common.BaseHandler;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTask
implements Task {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final boolean PRIVILEGED_ACCESS = true;
    private final BaseHandler handler;
    private final Task.Type taskType;
    private final boolean requiresPrivilegedAccess;
    private final SearchStatus statusChecker;

    protected BaseTask(BaseHandler handler, Task.Type taskType, boolean requiresPrivilegedAccess) {
        this(handler, taskType, requiresPrivilegedAccess, new SearchStatus());
    }

    protected BaseTask(BaseHandler handler, Task.Type taskType, boolean requiresPrivilegedAccess, SearchStatus statusChecker) {
        this.handler = handler;
        this.taskType = taskType;
        this.requiresPrivilegedAccess = requiresPrivilegedAccess;
        this.statusChecker = statusChecker;
    }

    protected abstract Response executeTask();

    protected Logger getLog() {
        return LOG;
    }

    @Override
    public Task.Type getType() {
        return this.taskType;
    }

    @Override
    public Response call() throws Exception {
        try {
            this.failIfNotInitialized();
            this.maybeValidateRequest();
            return this.executeTask();
        }
        catch (Exception e) {
            return this.buildErrorResponse(e);
        }
    }

    protected void failIfNotInitialized() {
        if (!this.statusChecker.isInitialized()) {
            throw new SearchException(SearchMessageKeys.INTERNAL_ERROR, "Search not Initialized", 503);
        }
    }

    private void maybeValidateRequest() {
        if (this.requiresPrivilegedAccess) {
            this.handler.validateRequestForTrustedOrSysAdmin();
        }
    }

    protected void logResponse(Response response) {
        this.handler.logResponse(response);
    }

    protected void saveRequestContext() {
        this.handler.saveRequestContext();
    }

    protected Response getCachedResponse(Date lastModified) {
        return this.handler.getCachedResponse(lastModified);
    }

    protected String buildBaseURL() {
        return this.handler.buildBaseURL();
    }

    protected Response buildResponse(Response.ResponseBuilder builder) {
        Response response = builder.build();
        this.logResponse(response);
        return response;
    }

    protected Response buildResponse(JsonObject payload) {
        Response response = Response.ok((Object)payload.toString(), (String)"application/json").build();
        this.logResponse(response);
        return response;
    }

    public Response buildErrorResponse(Exception cause) {
        SearchException searchException = SearchException.wrapIfNeeded(cause);
        Response response = searchException.buildResponse();
        this.logResponse(response);
        this.logStackTrace(searchException);
        return response;
    }

    private void logStackTrace(SearchException e) {
        if (e.getResponseStatus() == 500) {
            this.getLog().error("Internal error response caused by: ", (Throwable)((Object)e));
        } else {
            this.getLog().debug("Error response caused by: ", (Throwable)((Object)e));
        }
    }

    protected Response buildOkResponse() {
        Response response = Response.ok().build();
        this.logResponse(response);
        return response;
    }
}

