/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.common;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.handlers.indices.IIndicesController;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;

public class BatchProcessor {
    public void handleBatchRequest(IIndicesController controller, String indexId, JsonArray batchCommands) {
        try {
            BatchProcessor.tryToHandleBatchRequest(controller, indexId, batchCommands);
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "Failed to handle batch request", new Object[0]);
        }
    }

    private static void tryToHandleBatchRequest(IIndicesController controller, String indexId, JsonArray batchCommands) {
        for (Object command : batchCommands) {
            BatchProcessor.handleBatchCommand(controller, indexId, (JsonObject)command);
        }
    }

    private static void handleBatchCommand(IIndicesController controller, String indexId, JsonObject batchCommand) {
        BatchProcessor.addDocuments(controller, indexId, BatchProcessor.getObjects(batchCommand, "add"));
        BatchProcessor.updateDocuments(controller, indexId, BatchProcessor.getObjects(batchCommand, "update"));
        BatchProcessor.deleteDocuments(controller, indexId, BatchProcessor.getObjects(batchCommand, "delete"));
    }

    private static JsonArray getObjects(JsonObject batchCommand, String action) {
        return (JsonArray)batchCommand.get(action);
    }

    private static void addDocuments(IIndicesController controller, String indexId, JsonArray objectsToAdd) {
        if (BatchProcessor.isNotEmpty(objectsToAdd)) {
            controller.addDocuments(indexId, objectsToAdd);
        }
    }

    private static void updateDocuments(IIndicesController controller, String indexId, JsonArray objectsToUpdate) {
        if (BatchProcessor.isNotEmpty(objectsToUpdate)) {
            controller.updateDocuments(indexId, objectsToUpdate);
        }
    }

    private static void deleteDocuments(IIndicesController controller, String indexId, JsonArray objectsToDelete) {
        if (BatchProcessor.isNotEmpty(objectsToDelete)) {
            controller.deleteDocuments(indexId, objectsToDelete);
        }
    }

    private static boolean isNotEmpty(JsonArray objects) {
        return CollectionUtils.isNotEmpty((Collection)objects);
    }
}

