/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.common;

import com.ibm.bi.json.JsonObject;
import java.util.Date;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;

public class CacheableQueryResult {
    private final JsonObject objects;
    private final Date lastModified;

    public CacheableQueryResult(JsonObject objects, Date lastModified) {
        this.objects = objects;
        this.lastModified = lastModified != null ? new Date(lastModified.getTime()) : null;
    }

    public JsonObject getObjects() {
        return this.objects;
    }

    public Date getLastModified() {
        return new Date(this.lastModified.getTime());
    }

    public Response buildResponse() {
        Response.ResponseBuilder builder = Response.ok((Object)this.objects.toString(), (String)"application/json");
        if (this.lastModified != null) {
            CacheControl cc = new CacheControl();
            cc.setPrivate(true);
            cc.setMustRevalidate(true);
            builder = builder.lastModified(this.lastModified).cacheControl(cc);
        }
        return builder.build();
    }
}

