/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.common;

import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.handlers.common.HideInternal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class QueryParameters {
    private static final int DEFAULT_NUM_RESULTS = 1000;
    private static final int MAX_NUM_RESULTS = 10000;
    private String indexId;
    private String queryTerm;
    private String returnFields;
    private List<String> filters;
    private HideInternal hideInternal;
    private String ancestors;
    private String scope;
    private int maxResults = 1000;

    public String getIndexId() {
        return this.indexId;
    }

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getQueryTerm() {
        return this.queryTerm;
    }

    public void setQueryTerm(String term) {
        this.queryTerm = StringUtils.isEmpty((CharSequence)term) ? null : term;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = QueryParameters.getBoundaryAdjustedResultCount(maxResults);
    }

    private static int getBoundaryAdjustedResultCount(int requestedResultCount) {
        if (requestedResultCount == 0) {
            return 1000;
        }
        if (requestedResultCount > 0 && requestedResultCount <= 10000) {
            return requestedResultCount;
        }
        throw new SearchException(SearchMessageKeys.UNSUPPORTED_RESULT_COUNT, String.valueOf(requestedResultCount), String.valueOf(10000), 400);
    }

    public String getReturnFields() {
        return this.returnFields;
    }

    public void setReturnFields(String returnFields) {
        this.returnFields = returnFields;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public HideInternal getHideInternal() {
        return this.hideInternal;
    }

    public void setHideInternal(HideInternal hideInternal) {
        this.hideInternal = hideInternal;
    }

    public void setAncestors(String ancestors) {
        this.ancestors = ancestors;
    }

    public String getAncestors() {
        return this.ancestors;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public abstract boolean isEmpty();

    public abstract String getLang();
}

