/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.common;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.handlers.common.JSONBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

public class QueryResult {
    private static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String UTC_TIME_ZONE = "UTC";
    private static final SimpleOrderedMap<Object> NO_PARAMS = new SimpleOrderedMap();
    private static final FastDateFormat UTC_DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)TimeZone.getTimeZone("UTC"));
    private JsonArray results;
    private NamedList responseHeader;
    private SolrQuery solrQuery;

    public QueryResult(SolrDocumentList results, NamedList responseHeader, SolrQuery solrQuery) {
        this.results = QueryResult.getResults(results);
        this.responseHeader = responseHeader;
        this.solrQuery = solrQuery;
    }

    private static JsonArray getResults(SolrDocumentList solrDocuments) {
        JsonArray json = new JsonArray();
        QueryResult.addResultsTo(json, solrDocuments);
        return json;
    }

    private static void addResultsTo(JsonArray json, SolrDocumentList solrDocuments) {
        for (SolrDocument doc : solrDocuments) {
            json.add((Object)new JsonObject((Map)QueryResult.convertSolrDocumentToJsonConvertible(doc)));
        }
    }

    private static SolrDocument convertSolrDocumentToJsonConvertible(SolrDocument doc) {
        SolrDocument convertedDoc = QueryResult.convertSolrDateFieldsToString(doc);
        return QueryResult.convertSolrHighlightingToJson(convertedDoc);
    }

    private static SolrDocument convertSolrDateFieldsToString(SolrDocument doc) {
        for (Map.Entry entry : doc.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Date)) continue;
            doc.put((String)entry.getKey(), (Object)QueryResult.convertDateToSimpleDateFormat((Date)value));
        }
        return doc;
    }

    private static String convertDateToSimpleDateFormat(Date date) {
        return UTC_DATE_FORMATTER.format(date);
    }

    private static SolrDocument convertSolrHighlightingToJson(SolrDocument doc) {
        List<Object> highlighting = QueryResult.getHighlighting(doc);
        doc.put("highlighting", (Object)QueryResult.toJsonArray(highlighting));
        return doc;
    }

    private static List<Object> getHighlighting(SolrDocument doc) {
        Object highlighting = doc.get((Object)"highlighting");
        if (highlighting instanceof List) {
            return (List)highlighting;
        }
        if (highlighting != null) {
            return Arrays.asList(highlighting);
        }
        return Collections.emptyList();
    }

    private static JsonArray toJsonArray(List<Object> highlighting) {
        JsonArray ja = new JsonArray();
        for (Object o : highlighting) {
            SolrDocument highlight = (SolrDocument)o;
            ja.add((Object)QueryResult.toJSON(highlight));
        }
        return ja;
    }

    private static JsonObject toJSON(SolrDocument highlight) {
        JsonObject json = new JsonObject();
        for (String fieldName : highlight.getFieldNames()) {
            Collection fieldValues = highlight.getFieldValues(fieldName);
            json.put(fieldName, (Object)QueryResult.toJsonArray(fieldValues));
        }
        return json;
    }

    private static JsonArray toJsonArray(Collection<Object> objects) {
        JsonArray array = new JsonArray();
        for (Object o : objects) {
            array.add(o);
        }
        return array;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public JsonObject toJSON() {
        JsonObject json = JSONBuilder.buildResultsJson(this.results);
        json.put("params", (Object)this.getQueryParams());
        return json;
    }

    private JsonObject getQueryParams() {
        JsonObject json = new JsonObject();
        this.addQueryParamsTo(json);
        this.addQueryStringTo(json);
        return json;
    }

    private void addQueryParamsTo(JsonObject json) {
        SimpleOrderedMap<Object> params = this.getParamsFromResponseHeader();
        Iterator it = params.iterator();
        while (it.hasNext()) {
            QueryResult.addParamTo(json, (Map.Entry)it.next());
        }
    }

    private SimpleOrderedMap<Object> getParamsFromResponseHeader() {
        Object params = this.responseHeader != null ? this.responseHeader.get("params") : null;
        return params != null ? (SimpleOrderedMap)params : NO_PARAMS;
    }

    private static void addParamTo(JsonObject json, Map.Entry<String, Object> param) {
        json.put(param.getKey(), param.getValue());
    }

    private void addQueryStringTo(JsonObject json) {
        json.put("queryString", (Object)this.solrQuery.toString());
    }

    public List<String> getResultsIds() {
        ArrayList<String> resultIds = new ArrayList<String>();
        for (Object o : this.results) {
            JsonObject result = (JsonObject)o;
            resultIds.add(result.getString(FieldNames.ID.toString()));
        }
        return resultIds;
    }
}

