/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.common;

import com.ibm.bi.search.async.Task;
import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.common.BaseTask;
import com.ibm.bi.search.handlers.common.QueryController;
import com.ibm.bi.search.handlers.common.QueryParameters;
import com.ibm.bi.search.util.RequestContext;
import java.util.Date;
import javax.ws.rs.core.Response;

public abstract class QueryTask
extends BaseTask {
    private final QueryParameters qp;
    private final QueryController queryController;

    protected QueryTask(BaseHandler handler, QueryParameters qp, QueryController queryController) {
        super(handler, Task.Type.READ_ONLY, false);
        this.qp = qp;
        this.queryController = queryController;
    }

    protected QueryParameters getQP() {
        return this.qp;
    }

    protected QueryController getQueryController() {
        return this.queryController;
    }

    @Override
    protected Response executeTask() {
        this.updateRequestContext();
        Response response = this.getCachedResponse(this.getLastModifiedDate());
        if (response == null) {
            response = this.invokeController();
        }
        this.logResponse(response);
        return response;
    }

    protected void updateRequestContext() {
        this.saveRequestContext();
        RequestContext.setHideInternal(this.getQP().getHideInternal());
    }

    private Date getLastModifiedDate() {
        String indexId = this.getQP().getIndexId();
        return this.getQueryController().getLastModified(indexId);
    }

    protected abstract Response invokeController();
}

