/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.common;

import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import java.util.LinkedHashMap;

public class SolrQueryParameters
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public SolrQueryParameters(Object ... keyValuePairs) {
        SolrQueryParameters.validate(keyValuePairs);
        this.store(keyValuePairs);
    }

    private static void validate(Object ... keyValuePairs) {
        if (SolrQueryParameters.isOdd(keyValuePairs.length)) {
            throw SolrQueryParameters.createException("A query parameter value is missing ({}).", keyValuePairs);
        }
    }

    private static boolean isOdd(int number) {
        return number % 2 > 0;
    }

    private static SearchException createException(String msg, Object ... args) {
        return new SearchException(SearchMessageKeys.INTERNAL_ERROR, String.format(msg, args));
    }

    private void store(Object[] keyValuePairs) {
        int i = 0;
        while (i < keyValuePairs.length) {
            String key = SolrQueryParameters.validateKey(keyValuePairs[i++]);
            Object value = keyValuePairs[i++];
            this.storeIfItHasAValue(key, value);
        }
    }

    private static String validateKey(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        throw SolrQueryParameters.createException("Query parameter '{}' is not a String.", key);
    }

    private void storeIfItHasAValue(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }
}

