/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.healthcheck;

import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.healthcheck.HealthTask;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/health")
@Api(value="/health", description="Probes to check liveness and readiness of search container")
public class HealthHandler
extends BaseHandler {
    @GET
    @Path(value="readiness")
    @ApiOperation(value="Readiness probe to know when search container is ready to start accepting traffic", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=503, message="Service unavailable")})
    public Response readiness() {
        return this.healthCheck();
    }

    @GET
    @Path(value="liveness")
    @ApiOperation(value="Liveness probe to know when to restart search container", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=503, message="Service unavailable")})
    public Response liveness() {
        return this.healthCheck();
    }

    private Response healthCheck() {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        return this.callTask(HealthTask.create(this));
    }
}

