/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.indices;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.constants.SchemaProperties;
import com.ibm.bi.search.handlers.common.QueryResult;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.handlers.indices.IIndicesController;
import com.ibm.bi.search.indexing.solr.CollectionCreator;
import com.ibm.bi.search.indexing.solr.SolrHandlerFactory;
import com.ibm.bi.search.indexing.solr.SolrQueryFactory;
import com.ibm.bi.search.indexing.solr.cm.CMDocumentAdapter;
import com.ibm.bi.search.indexing.solr.feature.SmartsFeatureController;
import com.ibm.bi.search.indexing.solr.policies.PoliciesController;
import com.ibm.bi.search.util.Ancestors;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicesController
implements IIndicesController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrHandlerFactory solrFactory;
    private final SolrQueryFactory queryFactory;
    private final SmartsFeatureController featureController;
    private final PoliciesController policiesController;

    public IndicesController() {
        this(new SolrHandlerFactory(), new SolrQueryFactory(), new SmartsFeatureController(), new PoliciesController());
    }

    protected IndicesController(SolrHandlerFactory solrFactory, SolrQueryFactory queryFactory, SmartsFeatureController featureController, PoliciesController policiesController) {
        this.solrFactory = solrFactory;
        this.queryFactory = queryFactory;
        this.featureController = featureController;
        this.policiesController = policiesController;
    }

    @Override
    public void createIndex(JsonObject schema) {
        CollectionCreator creator = new CollectionCreator();
        creator.createCMCollection(schema.getString(SchemaProperties.INSTANCE.toString()), schema.getString(SchemaProperties.VERSION.toString()));
        this.featureController.createIndex(schema);
        this.policiesController.createIndex();
    }

    @Override
    public JsonObject getIndex(String indexId) {
        return this.solrFactory.createSolrHandler().getCore(indexId);
    }

    @Override
    public JsonObject getAllIndices() {
        return this.getIndex(IndexNames.CM.toString());
    }

    @Override
    public void addDocuments(String indexId, JsonArray documents) {
        this.updateDocuments(indexId, this.removeDuplicateDocuments(indexId, documents));
    }

    private JsonArray removeDuplicateDocuments(String indexId, JsonArray documents) {
        List<String> documentIds = IndicesController.extractIdsFromJsonArray(documents);
        SolrQueryParameters qp = this.queryFactory.createQueryByIds(documentIds);
        QueryResult duplicatesQueryResult = this.solrFactory.createSolrHandler().query(indexId, qp);
        return IndicesController.removeAllFoundDuplicates(duplicatesQueryResult.getResultsIds(), documents);
    }

    private static List<String> extractIdsFromJsonArray(JsonArray documents) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Object o : documents) {
            JsonObject document = (JsonObject)o;
            ids.add(document.getString(FieldNames.ID.toString()));
        }
        return ids;
    }

    private static JsonArray removeAllFoundDuplicates(List<String> removeIds, JsonArray documents) {
        JsonArray newDocuments = new JsonArray();
        ArrayList<String> addedDocumentIds = new ArrayList<String>();
        for (Object o : documents) {
            JsonObject document = (JsonObject)o;
            String documentId = document.getString(FieldNames.ID.toString());
            if (removeIds.contains(documentId)) {
                LOG.debug("The document with id: {} was not indexed because a document with this ID already exists.", (Object)document.getString(FieldNames.ID.toString()));
                continue;
            }
            if (addedDocumentIds.contains(documentId)) continue;
            addedDocumentIds.add(documentId);
            newDocuments.add((Object)document);
        }
        return newDocuments;
    }

    @Override
    public void updateDocuments(String indexId, JsonArray documents) {
        if (IndexNames.CM.toString().equals(indexId)) {
            LOG.trace("Formatting documents to index into CM collection.");
            documents = this.applyCMDocumentTransformation(documents);
        }
        this.solrFactory.createSolrHandler().addDocuments(indexId, documents);
        this.featureController.addDocuments(IndexNames.SMARTS_FEATURE.toString(), documents);
        this.policiesController.addDocuments(documents);
    }

    private JsonArray applyCMDocumentTransformation(JsonArray documents) {
        JsonArray newDocuments = new JsonArray();
        for (Object o : documents) {
            JsonObject document = (JsonObject)o;
            CMDocumentAdapter documentAdapter = new CMDocumentAdapter(document, this.queryAncestorDocuments(documents, document));
            newDocuments.add((Object)documentAdapter.adapt());
        }
        return newDocuments;
    }

    private JsonArray queryAncestorDocuments(JsonArray batchDocuments, JsonObject document) {
        ArrayList<String> ancestorIds = this.getMutableListOfAncestorIds(document);
        JsonArray ancestorDocuments = IndicesController.removeAncestorsAlreadyInTheBatch(ancestorIds, batchDocuments);
        ancestorDocuments.addAll((Collection)this.queryForRemainingAncestors(ancestorIds));
        return ancestorDocuments;
    }

    private ArrayList<String> getMutableListOfAncestorIds(JsonObject document) {
        List<String> unmutableList = Ancestors.getAncestorIds(document);
        return new ArrayList<String>(unmutableList);
    }

    private static JsonArray removeAncestorsAlreadyInTheBatch(List<String> ancestorIds, JsonArray batchDocuments) {
        JsonArray ancestorDocuments = new JsonArray();
        for (Object o : batchDocuments) {
            JsonObject document = (JsonObject)o;
            String id = document.getString(FieldNames.ID.toString());
            if (!ancestorIds.contains(id)) continue;
            ancestorIds.remove(id);
            ancestorDocuments.add((Object)document);
        }
        return ancestorDocuments;
    }

    private JsonArray queryForRemainingAncestors(List<String> ancestorIds) {
        SolrQueryParameters qp = this.queryFactory.createQueryByIds(ancestorIds);
        return this.solrFactory.createSolrHandler().query(IndexNames.CM.toString(), qp).toJSON().getArray("results");
    }

    @Override
    public void updatePermissions(String indexId, JsonArray permissions) {
        permissions.forEach(permission -> this.updateDocumentsForAllIds((JsonObject)permission));
    }

    private void updateDocumentsForAllIds(JsonObject permission) {
        QueryResult result = this.solrFactory.createSolrHandler().query(IndexNames.CM.toString(), this.queryFactory.createQueryByIds(this.getIdsToUpdate(permission)));
        this.updateDocuments(permission, result.toJSON().getArray("results"));
    }

    private List<String> getIdsToUpdate(JsonObject permission) {
        ArrayList<String> idsToUpdate = new ArrayList<String>();
        idsToUpdate.add(permission.getString(FieldNames.ID.toString()));
        JsonArray descendants = permission.getArray(SchemaProperties.DESCENDANTS.toString());
        if (descendants != null) {
            for (Object o : descendants) {
                idsToUpdate.add(o.toString());
            }
        }
        return idsToUpdate;
    }

    private void updateDocuments(JsonObject permission, JsonArray documents) {
        documents.forEach(doc -> this.updateDocument(permission, (JsonObject)doc));
    }

    private void cleanInternalProperties(JsonObject document) {
        document.remove((Object)FieldNames.SCORE.toString());
        document.remove((Object)FieldNames.INTERNAL_VERSION.toString());
        document.remove((Object)FieldNames.PERMISSIONS_GRANT.toString());
        document.remove((Object)FieldNames.PERMISSIONS_DENY.toString());
    }

    private void updateDocument(JsonObject permission, JsonObject document) {
        this.cleanInternalProperties(document);
        document.set(FieldNames.PERMISSIONS.toString(), (Object)permission.getObject(FieldNames.PERMISSIONS.toString()));
        this.policiesController.updatePermission(document);
    }

    @Override
    public void deleteDocument(String indexId, String objectId) {
        this.solrFactory.createSolrHandler().deleteDocument(indexId, objectId);
        this.featureController.deleteDocument(IndexNames.SMARTS_FEATURE.toString(), objectId);
        this.policiesController.deleteDocument(objectId);
    }

    @Override
    public void deleteDocuments(String indexId, JsonArray objectIds) {
        this.solrFactory.createSolrHandler().deleteDocumentsByQuery(indexId, this.queryFactory.createDeleteByQuery(objectIds));
        this.featureController.deleteDocuments(IndexNames.SMARTS_FEATURE.toString(), objectIds);
        this.policiesController.deleteDocuments(objectIds);
    }

    @Override
    public void deleteIndex(String indexId) {
        this.solrFactory.createSolrHandler().deleteCore(indexId);
        this.featureController.deleteIndex(IndexNames.SMARTS_FEATURE.toString());
        this.solrFactory.createSolrHandler().deleteCore(IndexNames.POLICIES.toString());
    }
}

