/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.indices;

import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.indices.tasks.AddDocumentsTask;
import com.ibm.bi.search.handlers.indices.tasks.BatchRequestTask;
import com.ibm.bi.search.handlers.indices.tasks.CreateIndexTask;
import com.ibm.bi.search.handlers.indices.tasks.DeleteDocumentTask;
import com.ibm.bi.search.handlers.indices.tasks.DeleteDocumentsTask;
import com.ibm.bi.search.handlers.indices.tasks.DeleteIndexTask;
import com.ibm.bi.search.handlers.indices.tasks.GetIndexTask;
import com.ibm.bi.search.handlers.indices.tasks.GetIndicesTask;
import com.ibm.bi.search.handlers.indices.tasks.UpdateDocumentsTask;
import com.ibm.bi.search.handlers.indices.tasks.UpdatePermissionsTask;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.invoke.MethodHandles;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/indices")
@Api(value="/indices", description="Index management")
public class IndicesHandler
extends BaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create new search index", notes="Create new search index. If the index already exists an error is returned.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Invalid payload"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=500, message="Internal error")})
    public Response createIndex(@ApiParam(name="schema", value="The JSON document describing the schema for the index.", required=true) String schema) {
        this.logRequest(this.httpServletRequest, this.uriInfo, schema);
        return this.callTask(new CreateIndexTask((BaseHandler)this, schema));
    }

    @GET
    @Path(value="{indexId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get information about an index.", notes="Get information about an index. If the index does not exit an error is returned.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Index not found"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=500, message="Internal error")})
    public Response getIndex(@PathParam(value="indexId") @ApiParam(name="indexId", value="The index the operation is performed in.", required=true) String indexId) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        return this.callTask(new GetIndexTask((BaseHandler)this, indexId));
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get information about all indices.", notes="Get information about all indices.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=500, message="Internal error")})
    public Response getAllIndices() {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        return this.callTask(new GetIndicesTask(this));
    }

    @POST
    @Path(value="{indexId}/objects")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create new index entry", notes="Create new index entry. Index entry content is driven by the index schema that was defined when the index was created.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=400, message="Invalid payload"), @ApiResponse(code=500, message="Internal error")})
    public Response addDocuments(@PathParam(value="indexId") @ApiParam(name="indexId", value="The index the operation is performed in.", required=true) String indexId, @ApiParam(name="sentDocument", value="JSON representation of the document to be added", required=true) String sentDocument) {
        this.logRequest(this.httpServletRequest, this.uriInfo, sentDocument);
        return this.callTask(new AddDocumentsTask((BaseHandler)this, indexId, sentDocument));
    }

    @PUT
    @Path(value="{indexId}/objects")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create new index entry", notes="Create new index entry. Index entry content is driven by the index schema that was defined when the index was created.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=400, message="Invalid payload"), @ApiResponse(code=500, message="Internal error")})
    public Response updateDocuments(@PathParam(value="indexId") @ApiParam(name="indexId", value="The index the operation is performed in.", required=true) String indexId, @ApiParam(name="sentDocument", value="JSON representation of the document to be updated", required=true) String sentDocument) {
        this.logRequest(this.httpServletRequest, this.uriInfo, sentDocument);
        return this.callTask(new UpdateDocumentsTask((BaseHandler)this, indexId, sentDocument));
    }

    @POST
    @Path(value="{indexId}/objects/batch")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Handles a batch request.", notes="Executes a group of add/update/delete commands.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Invalid payload"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=500, message="Internal error")})
    public Response batchRequest(@PathParam(value="indexId") @ApiParam(name="indexId", value="The index the operation is performed in.", required=true) String indexId, @ApiParam(name="payload", value="JSON representation of the batch to be processed", required=true) String payload) {
        this.logRequest(this.httpServletRequest, this.uriInfo, payload);
        return this.callTask(new BatchRequestTask((BaseHandler)this, indexId, payload));
    }

    @DELETE
    @Path(value="{indexId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete an index", notes="Erase all index contents and delete the index.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=500, message="Internal error")})
    public Response deleteIndex(@PathParam(value="indexId") @ApiParam(name="indexId", value="The index the operation is performed in.", required=true) String indexId) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        return this.callTask(new DeleteIndexTask((BaseHandler)this, indexId));
    }

    @DELETE
    @Path(value="{indexId}/objects/{objectId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a document from an index", notes="Deletes the document specified by the object id", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=500, message="Internal error")})
    public Response deleteDocument(@PathParam(value="indexId") @ApiParam(name="indexId", value="The index the operation is performed in.", required=true) String indexId, @PathParam(value="objectId") @ApiParam(name="objectId", value="The id of the document to be deleted.", required=true) String objectId) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        return this.callTask(new DeleteDocumentTask((BaseHandler)this, indexId, objectId));
    }

    @DELETE
    @Path(value="{indexId}/objects")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a set of documents from an index", notes="Deletes a set of documents from the index", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=500, message="Internal error")})
    public Response deleteDocuments(@PathParam(value="indexId") @ApiParam(name="indexId", value="The index the operation is performed in.", required=true) String indexId, @ApiParam(name="objectIds", value="JSON representation of the document ids to be deleted.", required=true) String objectIds) {
        this.logRequest(this.httpServletRequest, this.uriInfo, objectIds);
        return this.callTask(new DeleteDocumentsTask((BaseHandler)this, indexId, objectIds));
    }

    @PUT
    @Path(value="{indexId}/permissions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the ACL for the indexed document", notes="Update the ACL for the indexed document in this specific index", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=400, message="Invalid payload"), @ApiResponse(code=500, message="Internal error")})
    public Response updatePermissions(@PathParam(value="indexId") @ApiParam(name="indexId", value="The index the operation is performed in.", required=true) String indexId, @ApiParam(name="permissions", value="JSON representation of the permissions to be updated.", required=true) String permissions) {
        this.logRequest(this.httpServletRequest, this.uriInfo, permissions);
        return this.callTask(new UpdatePermissionsTask((BaseHandler)this, indexId, permissions));
    }
}

