/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.indices.tasks;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.async.Task;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.constants.SchemaProperties;
import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.common.BaseTask;
import com.ibm.bi.search.handlers.common.JSONBuilder;
import com.ibm.bi.search.handlers.indices.IndicesController;

public abstract class IndicesTask
extends BaseTask {
    private final IndicesController controller = new IndicesController();

    protected IndicesTask(BaseHandler handler, Task.Type taskType) {
        super(handler, taskType, true);
    }

    public IndicesController getController() {
        return this.controller;
    }

    protected static JsonArray parsePayload(String payload, String arrayName) {
        JsonObject jsonPayload = JSONBuilder.parseJsonObject(payload);
        return (JsonArray)jsonPayload.get(arrayName);
    }

    protected JsonArray parseDocuments(String documents) {
        JsonObject documentsJson = JSONBuilder.parseJsonObject(documents);
        Object objects = documentsJson.get(SchemaProperties.OBJECTS.toString());
        if (objects == null) {
            return JSONBuilder.wrapInJsonArray(documentsJson);
        }
        if (objects instanceof JsonArray) {
            return (JsonArray)objects;
        }
        throw new SearchException(SearchMessageKeys.INVALID_DATA_FORMAT, 400);
    }
}

