/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.search;

import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.common.HideInternal;
import com.ibm.bi.search.handlers.common.SearchQueryParameters;
import com.ibm.bi.search.handlers.search.SearchTask;
import com.ibm.bi.search.util.RESTHelper;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/search")
@Api(value="/search", description="Searching index contents for specific search terms")
public class SearchHandler
extends BaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public SearchHandler() {
        this(new RESTHelper());
    }

    protected SearchHandler(RESTHelper restHelper) {
        super(restHelper);
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @GET
    @Path(value="/{indexId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search for the specified string", notes="Search for the specified list of search terms (**Note: in the initial implementation only a single search term is supported**). Search is case-insensitive. The search goes against a specified index. Search parameters modify search behavior - filtering search results, highlighting matches and selecting what fields to return.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response get(@PathParam(value="indexId") @ApiParam(name="indexId", value="The index the operation is performed in.", required=true) String indexId, @QueryParam(value="query") @ApiParam(name="query", value="The search string consisting of search terms separated by spaces. No search operators are currently supported.", required=false) String query, @QueryParam(value="fields") @ApiParam(name="fields", value="The list of fields to be included in the returned documents. Values are separated with '|'.", required=false) String returnFields, @QueryParam(value="results") @ApiParam(name="results", value="The number of search results to be returned. ", required=false) int results, @QueryParam(value="facet") @ApiParam(name="facet", value="The facet information to be returned in the search result. The first value in the array is the name of the field, the second value in the array is the maximum number of labels to be returned. Additional values are one or more ranges used only for fields of DATE type. Each range consists of 5 values: label, min, max, mininclusive, maxinclusive. More than one such parameter can be defined. Values are separated with '|'.", required=false) List<String> facet, @QueryParam(value="filter") @ApiParam(name="filter", value="The field in the index and a list of allowed values, or a range, for that field that will be used to limit the search results. The first value in the array is the name of the field. For field types other than DATE, the rest values in the array are the values for the field. For field type DATE, the rest of the 4 values are: min, max, mininclusive, maxinclusive. More than one such parameter can be defined. Values are separated with '|'. ", required=false) List<String> filter, @QueryParam(value="lang") @ApiParam(name="lang", value="The list of languages that will be used to search. Values are separated with '|'. By default the product locale defined in preference is used as the search language.", required=false) String lang, @QueryParam(value="hide_internal") @ApiParam(name="hide_internal", value="Controls whether the internal objects should show up in the search results. Valid values are 'all', 'default' and 'none'. 'all' means hiding all internal objects, 'default' means only hiding objects under the accounts of other users, 'none' means to hide nothing. When nothing is specified 'default' is assumed.", required=false) String hideInternal, @QueryParam(value="hideUnknown") @ApiParam(name="hideUnknown", value="Controls whether objects with unknown visibility permissions should be excluded from search results. The default value is false (neutral). If the value is set to true, objects with unknown visibility will always be skipped.", required=false) boolean hideUnknown, @QueryParam(value="ignoreHiddenAncestor") @ApiParam(name="ignoreHiddenAncestor", value="Controls whether the object's ancestors hidden status will be checked or not.The default value is false. If the value is set to true, the ancestors hidden status checking will be skipped. ", required=false) boolean ignoreHiddenAncestor, @QueryParam(value="ancestors") @ApiParam(name="ancestors", value="The storeIDs of one or more ancestors as an additional filter to the query. Only documents located under these ancestors (including descendants) will be returned in the results. The storeID values must be separated with '|' characters.") String ancestors, @QueryParam(value="scope") @ApiParam(name="scope", value="Specify either 'mycontent' or 'teamcontent' to add an additional filter on search results based on the folder location of a document.") String scope) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        SearchQueryParameters qp = new SearchQueryParameters();
        qp.setIndexId(indexId);
        qp.setQueryTerm(query);
        qp.setReturnFields(returnFields);
        qp.setMaxResults(results);
        qp.setFacet(facet);
        qp.setFilters(filter);
        qp.setLang(lang);
        qp.setHideInternal(HideInternal.parse(hideInternal));
        qp.setHideUnknown(hideUnknown);
        qp.setIgnoreHiddenAncestor(ignoreHiddenAncestor);
        qp.setAncestors(ancestors);
        qp.setScope(scope);
        return this.callTask(new SearchTask(this, qp));
    }
}

