/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.select;

import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.handlers.select.tasks.SelectBatchQueryTask;
import com.ibm.bi.search.handlers.select.tasks.SelectQueryTask;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/select")
@Api(value="/select", description="Searching index contents for specific search terms.")
public class SelectHandler
extends BaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Context
    private Request rsRequest;

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @GET
    @Path(value="batch/{collectionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Perform a search query", notes="The search is performed on a specified index by using Solr query syntax. For more information about Solr query syntax, please refer to the official Solr documentation: https://lucene.apache.org/solr/guide/6_6/query-syntax-and-parsing.html\nFor examples of DisMax Queries see: https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-ExamplesofQueriesSubmittedtotheDisMaxQueryParser", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response getBatch(@PathParam(value="collectionId") @ApiParam(name="collectionId", value="The collection the operation is performed on.", required=true) String collectionId, @QueryParam(value="query") @ApiParam(name="queries", value="Specify search queries by using the official Solr query syntax.<p><ul style='font-size:x-small;font-weight:normal'>Some examples:<li>text:hello - Search for 'text' fields with value 'hello'.</li><li>text:\"hello world\" - Search for 'text' fields with value 'hello world'.</li><li>text:hello OR text:bye - Search for 'text' fields with values either 'hello' or 'bye'.</li><li>text:hello AND type:folder - Search for documents of type 'folder' with value 'hello'.</li><li>text:hello^15 OR text:bye - Search for 'text' fields with either value 'hello' or 'bye'. Boost the results of fields with value 'hello'.</li><li>Use the wildcard to search for the terms within a field value.</li></ul>", required=true) List<String> queries, @QueryParam(value="defType") @ApiParam(name="defType", value="Selects the query parser to be used to process the query.<ul style='font-size:x-small;font-weight:normal'><p>The defType parameter selects the query parser that Solr should use to process the main query parameter in the request. For example:<p>defType=dismax<p>If no defType param is specified, then by default, the The Standard Query Parser is used. (eg: defType=lucene)</ul>", required=false) String defType, @QueryParam(value="locale") @ApiParam(name="locale", value="A list of locale keys to perform queries against. All query parameters will be executed across multiple collections, and the results will be combined into one result set sorted by score. If empty, only the default collectionId will be queried.", required=false) List<String> locale, @QueryParam(value="sort") @ApiParam(name="sort", value="Sorts the response to a query in either ascending or descending order based on the response\u2019s score or another specified characteristic.<ul style='font-size:x-small;font-weight:normal'><p>The sort parameter arranges search results in either ascending (asc) or descending (desc) order. The parameter can be used with either numerical or alphabetical content. The directions can be entered in either all lowercase or all uppercase letters (i.e., both asc or ASC). Examples:<li>score desc - Sorts in descending order from the highest score to the lowest score.</li><li>price asc - Sorts in ascending order of the price field.</li><li>inStock desc, price asc - Sorts by the contents of the inStock field in descending order, then within those results sorts in ascending order by the contents of the price field.</li><p>If the sort parameter is omitted, sorting is performed as though the parameter were set to score desc.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/common-query-parameters.html#CommonQueryParameters-ThesortParameter\">More information.</a></ul>", required=false) String sort, @QueryParam(value="start") @ApiParam(name="start", value="Specifies an offset (by default, 0) into the responses at which Solr should begin displaying content.<ul style='font-size:x-small;font-weight:normal'><p>When specified, the start parameter specifies an offset into a query\u2019s result set and instructs Solr to begin displaying results from this offset.<p>The default value is \"0\". In other words, by default, Solr returns results without an offset, beginning where the results themselves begin.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/common-query-parameters.html#CommonQueryParameters-ThestartParameter\">More information.</a></ul>", required=false) String start, @QueryParam(value="rows") @ApiParam(name="rows", value="Controls how many rows of responses are displayed at a time (default value: 10).<ul style='font-size:x-small;font-weight:normal'><p>You can use the rows parameter to paginate results from a query. The parameter specifies the maximum number of documents from the complete result set that Solr should return to the client at one time.<p>The default value is 10. That is, by default, Solr returns 10 documents at a time in response to a query.</ul>", required=false) String rows, @QueryParam(value="fq") @ApiParam(name="fq", value="Applies a filter query to the search results.<ul style='font-size:x-small;font-weight:normal'><p>The fq parameter defines a query that can be used to restrict the superset of documents that can be returned, without influencing score. It can be very useful for speeding up complex queries, since the queries specified with fq are cached independently of the main query. When a later query uses the same filter, there\u2019s a cache hit, and filter results are returned quickly from the cache.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/common-query-parameters.html#CommonQueryParameters-Thefq_FilterQuery_Parameter\">More information.</a></ul>", required=false) List<String> fq, @QueryParam(value="fl") @ApiParam(name="fl", value="Limits the information included in a query response to a specified list of fields. The fields need to either be stored=\"true\" or docValues=\"true\".<ul style='font-size:x-small;font-weight:normal'><p>The fl parameter limits the information included in a query response to a specified list of fields. The fields need to either be stored=\"true\" or docValues=\"true\".<p>The field list can be specified as a space-separated or comma-separated list of field names. The string \"score\" can be used to indicate that the score of each document for the particular query should be returned as a field. The wildcard character * selects all the fields in the document which are either stored=\"true\" or docValues=\"true\" and useDocValuesAsStored=\"true\" (which is the default when docValues are enabled). You can also add pseudo-fields, functions and transformers to the field list request.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/common-query-parameters.html#CommonQueryParameters-Thefl_FieldList_Parameter\">More information.</a></ul>", required=false) String fl, @QueryParam(value="q.alt") @ApiParam(name="q.alt", value="Calls the standard query parser and defines query input strings, when the q parameter is not used.<ul style='font-size:x-small;font-weight:normal'><p>If specified, the q.alt parameter defines a query (which by default will be parsed using standard query parsing syntax) when the main q parameter is not specified or is blank. The q.alt parameter comes in handy when you need something like a query to match all documents (don\u2019t forget &rows=0 for that one!) in order to get collection-wide faceting counts.</ul>", required=false) String qAlt, @QueryParam(value="qf") @ApiParam(name="qf", value="Query Fields: specifies the fields in the index on which to perform the query. If absent, defaults to df.<ul style='font-size:x-small;font-weight:normal'><p>The qf parameter introduces a list of fields, each of which is assigned a boost factor to increase or decrease that particular field\u2019s importance in the query. For example, the query below:<li>qf=\"fieldOne^2.3 fieldTwo fieldThree^0.4\"</li><p>assigns fieldOne a boost of 2.3, leaves fieldTwo with the default boost (because no boost factor is specified), and fieldThree a boost of 0.4. These boost factors make matches in fieldOne much more significant than matches in fieldTwo, which in turn are much more significant than matches in fieldThree.</ul>", required=false) String qf, @QueryParam(value="mm") @ApiParam(name="mm", value="Minimum \"Should\" Match: specifies a minimum number of clauses that must match in a query.<ul style='font-size:x-small;font-weight:normal'><p>If no 'mm' parameter is specified in the query, or as a default in solrconfig.xml, the effective value of the q.op parameter (either in the query, as a default in solrconfig.xml, or from the defaultOperator option in the Schema) is used to influence the behavior. If q.op is effectively AND\u2019ed, then mm=100%; if q.op is OR\u2019ed, then mm=1. Users who want to force the legacy behavior should set a default value for the 'mm' parameter in their solrconfig.xml file. Users should add this as a configured default for their request handlers. This parameter tolerates miscellaneous white spaces in expressions (e.g., \" 3 < -25% 10 < -3\\n\", \" \\n-25%\\n \", \" \\n3\\n \").<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Themm_MinimumShouldMatch_Parameter\">More information.</a></ul>", required=false) String mm, @QueryParam(value="pf") @ApiParam(name="pf", value="Phrase Fields: boosts the score of documents in cases where all of the terms in the q parameter appear in close proximity.<ul style='font-size:x-small;font-weight:normal'><p>Once the list of matching documents has been identified using the fq and qf parameters, the pf parameter can be used to \"boost\" the score of documents in cases where all of the terms in the q parameter appear in close proximity.<p>The format is the same as that used by the qf parameter: a list of fields and \"boosts\" to associate with each of them when making phrase queries out of the entire q parameter.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Thepf_PhraseFields_Parameter\">More information.</a></ul>", required=false) String pf, @QueryParam(value="ps") @ApiParam(name="ps", value="Phrase Slop: specifies the number of positions two terms can be apart in order to match the specified phrase.<ul style='font-size:x-small;font-weight:normal'><p>For DisMax queries, the ps parameter specifies the amount of \"phrase slop\" to apply to queries specified with the pf parameter. Phrase slop is the number of positions one token needs to be moved in relation to another token in order to match a phrase specified in a query.<p>For Extended DisMax (eDisMax) queries, this is default amount of slop on phrase queries built with pf, pf2 and/or pf3 fields (affects boosting).<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Theps_PhraseSlop_Parameter\">More information on DisMax.</a><p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-ThepsParameter\">More information on eDisMax.</a></ul>", required=false) String ps, @QueryParam(value="qs") @ApiParam(name="qs", value="Query Phrase Slop: specifies the number of positions two terms can be apart in order to match the specified phrase. Used specifically with the qf parameter.<ul style='font-size:x-small;font-weight:normal'><p>The qs parameter specifies the amount of slop permitted on phrase queries explicitly included in the user\u2019s query string with the qf parameter. As explained above, slop refers to the number of positions one token needs to be moved in relation to another token in order to match a phrase specified in a query.\n<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Theqs_QueryPhraseSlop_Parameter\">More information.</a></ul>", required=false) String qs, @QueryParam(value="tie") @ApiParam(name="tie", value="Tie Breaker: specifies a float value (which should be something much less than 1) to use as tiebreaker in DisMax queries. Default: 0.0<ul style='font-size:x-small;font-weight:normal'><p>When a term from the user\u2019s input is tested against multiple fields, more than one field may match. If so, each field will generate a different score based on how common that word is in that field (for each document relative to all other documents). The tie parameter lets you control how much the final score of the query will be influenced by the scores of the lower scoring fields compared to the highest scoring field.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Thetie_TieBreaker_Parameter\">More information.</a></ul>", required=false) String tie, @QueryParam(value="bq") @ApiParam(name="bq", value="Boost Query: specifies a factor by which a term or phrase should be 'boosted' in importance when considering a match.<ul style='font-size:x-small;font-weight:normal'><p>The bq parameter specifies an additional, optional, query clause that will be added to the user\u2019s main query to influence the score. For example, if you wanted to add a relevancy boost for recent documents:<p>q=cheese<p>bq=date:[NOW/DAY-1YEAR TO NOW/DAY]<p>You can specify multiple bq parameters by separating clauses with spaces. E.g., bq=name:John^2 city:Ottawa^3</ul>", required=false) String bq, @QueryParam(value="bf") @ApiParam(name="bf", value="Boost Functions: specifies functions to be applied to boosts. (See for details about function queries.)<ul style='font-size:x-small;font-weight:normal'><p>The bf parameter specifies functions (with optional boosts) that will be used to construct FunctionQueries which will be added to the user\u2019s main query as optional clauses that will influence the score. Any function supported natively by Solr can be used, along with a boost value. For example:<p>recip(rord(myfield),1,2,3)^1.5<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Thebf_BoostFunctions_Parameter\">More information.</a></ul>", required=false) String bf, @QueryParam(value="sow") @ApiParam(name="sow", value="The sow Parameter: Split on whitespace: if set to false, whitespace-separated term sequences will be provided to text analysis in one shot, enabling proper function of analysis filters that operate over term sequences, e.g. multi-word synonyms and shingles. Defaults to true: text analysis is invoked separately for each individual whitespace-separated term.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-ThesowParameter\">More information.</a></ul>", required=false) String sow, @QueryParam(value="mm.autoRelax") @ApiParam(name="mm.autoRelax", value="If true, the number of clauses required (minimum should match) will automatically be relaxed if a clause is removed (by e.g. stopwords filter) from some but not all qf fields. Use this parameter as a workaround if you experience that queries return zero hits due to uneven stopword removal between the qf fields.<p>Note that relaxing mm may cause undesired side effects, hurting the precision of the search, depending on the nature of your index content.\n<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-Themm.autoRelaxParameter\">More information.</a></ul>", required=false) String mmAutoRelax, @QueryParam(value="boost") @ApiParam(name="boost", value="A multivalued list of strings parsed as queries with scores multiplied by the score from the main query for all matching documents. This parameter is shorthand for wrapping the query produced by eDisMax using the BoostQParserPlugin.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-TheboostParameter\">More information.</a></ul>", required=false) String boost, @QueryParam(value="lowercaseOperators") @ApiParam(name="lowercaseOperators", value="A Boolean parameter indicating if lowercase \"and\" and \"or\" should be treated the same as operators \"AND\" and \"OR\".<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-ThelowercaseOperatorsParameter\">More information.</a></ul>", required=false) String lowercaseOperators, @QueryParam(value="pf2") @ApiParam(name="pf2", value="A multivalued list of fields with optional weights, based on pairs of word shingles.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-Thepf2Parameter\">More information.</a></ul>", required=false) String pf2, @QueryParam(value="ps2") @ApiParam(name="ps2", value="This is similar to ps but overrides the slop factor used for pf2. If not specified, ps is used.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-Theps2Parameter\">More information.</a></ul>", required=false) String ps2, @QueryParam(value="pf3") @ApiParam(name="pf3", value="A multivalued list of fields with optional weights, based on triplets of word shingles. Similar to pf, except that instead of building a phrase per field out of all the words in the input, it builds a set of phrases for each field out of each triplet of word shingles.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-Thepf3Parameter\">More information.</a></ul>", required=false) String pf3, @QueryParam(value="ps3") @ApiParam(name="ps3", value="This is similar to ps but overrides the slop factor used for pf3. If not specified, ps is used.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-Theps3Parameter\">More information.</a></ul>", required=false) String ps3, @QueryParam(value="stopwords") @ApiParam(name="stopwords", value="A Boolean parameter indicating if the StopFilterFactory configured in the query analyzer should be respected when parsing the query: if it is false, then the StopFilterFactory in the query analyzer is ignored.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-ThestopwordsParameter\">More information.</a></ul>", required=false) String stopwords, @QueryParam(value="uf") @ApiParam(name="uf", value="Specifies which schema fields the end user is allowed to explicitly query. This parameter supports wildcards. The default is to allow all fields, equivalent to uf=*. To allow only title field, use uf=title. To allow title and all fields ending with '_s', use uf=title,*_s. To allow all fields except title, use uf=*,-title. To disallow all fielded searches, use uf=-*.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-TheufParameter\">More information.</a></ul>", required=false) String uf, @QueryParam(value="assetTypes") @ApiParam(name="assetTypes", value="Specifies which CM types should be returned when querying 'smarts_feature' index. Should be expressed with pipe separating values. Valid values include: module, package, dataset2,uploadedFile, and dataSourceSchema. By default, all values will be included.E.g. module|package|uploadedFile ", required=false) String assetTypes) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        SolrQueryParameters qp = new SolrQueryParameters("defType", defType, "sort", sort, "start", start, "rows", rows, "fq", fq, "fl", fl, "q.alt", qAlt, "qf", qf, "mm", mm, "pf", pf, "ps", ps, "qs", qs, "tie", tie, "bq", bq, "bf", bf, "sow", sow, "mm.autoRelax", mmAutoRelax, "boost", boost, "lowercaseOperators", lowercaseOperators, "pf2", pf2, "ps2", ps2, "pf3", pf3, "ps3", ps3, "stopwords", stopwords, "uf", uf, "assetTypes", assetTypes);
        return this.callTask(new SelectBatchQueryTask(this, collectionId, qp, queries, locale));
    }

    @GET
    @Path(value="/{collectionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Perform a search query", notes="The search is performed on a specified index by using Solr query syntax. For more information about Solr query syntax, please refer to the official Solr documentation: https://lucene.apache.org/solr/guide/6_6/query-syntax-and-parsing.html\nFor examples of DisMax Queries see: https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-ExamplesofQueriesSubmittedtotheDisMaxQueryParser", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response get(@PathParam(value="collectionId") @ApiParam(name="collectionId", value="The collection the operation is performed on.", required=true) String collectionId, @QueryParam(value="query") @ApiParam(name="query", value="Specify a search query by using the official Solr query syntax.<p><ul style='font-size:x-small;font-weight:normal'>Some examples:<li>text:hello - Search for 'text' fields with value 'hello'.</li><li>text:\"hello world\" - Search for 'text' fields with value 'hello world'.</li><li>text:hello OR text:bye - Search for 'text' fields with values either 'hello' or 'bye'.</li><li>text:hello AND type:folder - Search for documents of type 'folder' with value 'hello'.</li><li>text:hello^15 OR text:bye - Search for 'text' fields with either value 'hello' or 'bye'. Boost the results of fields with value 'hello'.</li><li>Use the wildcard to search for the terms within a field value.</li></ul>", required=true) String query, @QueryParam(value="defType") @ApiParam(name="defType", value="Selects the query parser to be used to process the query.<ul style='font-size:x-small;font-weight:normal'><p>The defType parameter selects the query parser that Solr should use to process the main query parameter in the request. For example:<p>defType=dismax<p>If no defType param is specified, then by default, the The Standard Query Parser is used. (eg: defType=lucene)</ul>", required=false) String defType, @QueryParam(value="locale") @ApiParam(name="locale", value="A list of locale keys to perform queries against. All query parameters will be executed across multiple collections, and the results will be combined into one result set sorted by score. If empty, only the default collectionId will be queried.", required=false) List<String> locale, @QueryParam(value="sort") @ApiParam(name="sort", value="Sorts the response to a query in either ascending or descending order based on the response\u2019s score or another specified characteristic.<ul style='font-size:x-small;font-weight:normal'><p>The sort parameter arranges search results in either ascending (asc) or descending (desc) order. The parameter can be used with either numerical or alphabetical content. The directions can be entered in either all lowercase or all uppercase letters (i.e., both asc or ASC). Examples:<li>score desc - Sorts in descending order from the highest score to the lowest score.</li><li>price asc - Sorts in ascending order of the price field.</li><li>inStock desc, price asc - Sorts by the contents of the inStock field in descending order, then within those results sorts in ascending order by the contents of the price field.</li><p>If the sort parameter is omitted, sorting is performed as though the parameter were set to score desc.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/common-query-parameters.html#CommonQueryParameters-ThesortParameter\">More information.</a></ul>", required=false) String sort, @QueryParam(value="start") @ApiParam(name="start", value="Specifies an offset (by default, 0) into the responses at which Solr should begin displaying content.<ul style='font-size:x-small;font-weight:normal'><p>When specified, the start parameter specifies an offset into a query\u2019s result set and instructs Solr to begin displaying results from this offset.<p>The default value is \"0\". In other words, by default, Solr returns results without an offset, beginning where the results themselves begin.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/common-query-parameters.html#CommonQueryParameters-ThestartParameter\">More information.</a></ul>", required=false) String start, @QueryParam(value="rows") @ApiParam(name="rows", value="Controls how many rows of responses are displayed at a time (default value: 10).<ul style='font-size:x-small;font-weight:normal'><p>You can use the rows parameter to paginate results from a query. The parameter specifies the maximum number of documents from the complete result set that Solr should return to the client at one time.<p>The default value is 10. That is, by default, Solr returns 10 documents at a time in response to a query.</ul>", required=false) String rows, @QueryParam(value="fq") @ApiParam(name="fq", value="Applies a filter query to the search results.<ul style='font-size:x-small;font-weight:normal'><p>The fq parameter defines a query that can be used to restrict the superset of documents that can be returned, without influencing score. It can be very useful for speeding up complex queries, since the queries specified with fq are cached independently of the main query. When a later query uses the same filter, there\u2019s a cache hit, and filter results are returned quickly from the cache.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/common-query-parameters.html#CommonQueryParameters-Thefq_FilterQuery_Parameter\">More information.</a></ul>", required=false) List<String> fq, @QueryParam(value="fl") @ApiParam(name="fl", value="Limits the information included in a query response to a specified list of fields. The fields need to either be stored=\"true\" or docValues=\"true\".<ul style='font-size:x-small;font-weight:normal'><p>The fl parameter limits the information included in a query response to a specified list of fields. The fields need to either be stored=\"true\" or docValues=\"true\".<p>The field list can be specified as a space-separated or comma-separated list of field names. The string \"score\" can be used to indicate that the score of each document for the particular query should be returned as a field. The wildcard character * selects all the fields in the document which are either stored=\"true\" or docValues=\"true\" and useDocValuesAsStored=\"true\" (which is the default when docValues are enabled). You can also add pseudo-fields, functions and transformers to the field list request.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/common-query-parameters.html#CommonQueryParameters-Thefl_FieldList_Parameter\">More information.</a></ul>", required=false) String fl, @QueryParam(value="q.alt") @ApiParam(name="q.alt", value="Calls the standard query parser and defines query input strings, when the q parameter is not used.<ul style='font-size:x-small;font-weight:normal'><p>If specified, the q.alt parameter defines a query (which by default will be parsed using standard query parsing syntax) when the main q parameter is not specified or is blank. The q.alt parameter comes in handy when you need something like a query to match all documents (don\u2019t forget &rows=0 for that one!) in order to get collection-wide faceting counts.</ul>", required=false) String qAlt, @QueryParam(value="qf") @ApiParam(name="qf", value="Query Fields: specifies the fields in the index on which to perform the query. If absent, defaults to df.<ul style='font-size:x-small;font-weight:normal'><p>The qf parameter introduces a list of fields, each of which is assigned a boost factor to increase or decrease that particular field\u2019s importance in the query. For example, the query below:<li>qf=\"fieldOne^2.3 fieldTwo fieldThree^0.4\"</li><p>assigns fieldOne a boost of 2.3, leaves fieldTwo with the default boost (because no boost factor is specified), and fieldThree a boost of 0.4. These boost factors make matches in fieldOne much more significant than matches in fieldTwo, which in turn are much more significant than matches in fieldThree.</ul>", required=false) String qf, @QueryParam(value="mm") @ApiParam(name="mm", value="Minimum \"Should\" Match: specifies a minimum number of clauses that must match in a query.<ul style='font-size:x-small;font-weight:normal'><p>If no 'mm' parameter is specified in the query, or as a default in solrconfig.xml, the effective value of the q.op parameter (either in the query, as a default in solrconfig.xml, or from the defaultOperator option in the Schema) is used to influence the behavior. If q.op is effectively AND\u2019ed, then mm=100%; if q.op is OR\u2019ed, then mm=1. Users who want to force the legacy behavior should set a default value for the 'mm' parameter in their solrconfig.xml file. Users should add this as a configured default for their request handlers. This parameter tolerates miscellaneous white spaces in expressions (e.g., \" 3 < -25% 10 < -3\\n\", \" \\n-25%\\n \", \" \\n3\\n \").<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Themm_MinimumShouldMatch_Parameter\">More information.</a></ul>", required=false) String mm, @QueryParam(value="pf") @ApiParam(name="pf", value="Phrase Fields: boosts the score of documents in cases where all of the terms in the q parameter appear in close proximity.<ul style='font-size:x-small;font-weight:normal'><p>Once the list of matching documents has been identified using the fq and qf parameters, the pf parameter can be used to \"boost\" the score of documents in cases where all of the terms in the q parameter appear in close proximity.<p>The format is the same as that used by the qf parameter: a list of fields and \"boosts\" to associate with each of them when making phrase queries out of the entire q parameter.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Thepf_PhraseFields_Parameter\">More information.</a></ul>", required=false) String pf, @QueryParam(value="ps") @ApiParam(name="ps", value="Phrase Slop: specifies the number of positions two terms can be apart in order to match the specified phrase.<ul style='font-size:x-small;font-weight:normal'><p>For DisMax queries, the ps parameter specifies the amount of \"phrase slop\" to apply to queries specified with the pf parameter. Phrase slop is the number of positions one token needs to be moved in relation to another token in order to match a phrase specified in a query.<p>For Extended DisMax (eDisMax) queries, this is default amount of slop on phrase queries built with pf, pf2 and/or pf3 fields (affects boosting).<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Theps_PhraseSlop_Parameter\">More information on DisMax.</a><p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-ThepsParameter\">More information on eDisMax.</a></ul>", required=false) String ps, @QueryParam(value="qs") @ApiParam(name="qs", value="Query Phrase Slop: specifies the number of positions two terms can be apart in order to match the specified phrase. Used specifically with the qf parameter.<ul style='font-size:x-small;font-weight:normal'><p>The qs parameter specifies the amount of slop permitted on phrase queries explicitly included in the user\u2019s query string with the qf parameter. As explained above, slop refers to the number of positions one token needs to be moved in relation to another token in order to match a phrase specified in a query.\n<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Theqs_QueryPhraseSlop_Parameter\">More information.</a></ul>", required=false) String qs, @QueryParam(value="tie") @ApiParam(name="tie", value="Tie Breaker: specifies a float value (which should be something much less than 1) to use as tiebreaker in DisMax queries. Default: 0.0<ul style='font-size:x-small;font-weight:normal'><p>When a term from the user\u2019s input is tested against multiple fields, more than one field may match. If so, each field will generate a different score based on how common that word is in that field (for each document relative to all other documents). The tie parameter lets you control how much the final score of the query will be influenced by the scores of the lower scoring fields compared to the highest scoring field.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Thetie_TieBreaker_Parameter\">More information.</a></ul>", required=false) String tie, @QueryParam(value="bq") @ApiParam(name="bq", value="Boost Query: specifies a factor by which a term or phrase should be 'boosted' in importance when considering a match.<ul style='font-size:x-small;font-weight:normal'><p>The bq parameter specifies an additional, optional, query clause that will be added to the user\u2019s main query to influence the score. For example, if you wanted to add a relevancy boost for recent documents:<p>q=cheese<p>bq=date:[NOW/DAY-1YEAR TO NOW/DAY]<p>You can specify multiple bq parameters by separating clauses with spaces. E.g., bq=name:John^2 city:Ottawa^3</ul>", required=false) String bq, @QueryParam(value="bf") @ApiParam(name="bf", value="Boost Functions: specifies functions to be applied to boosts. (See for details about function queries.)<ul style='font-size:x-small;font-weight:normal'><p>The bf parameter specifies functions (with optional boosts) that will be used to construct FunctionQueries which will be added to the user\u2019s main query as optional clauses that will influence the score. Any function supported natively by Solr can be used, along with a boost value. For example:<p>recip(rord(myfield),1,2,3)^1.5<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-dismax-query-parser.html#TheDisMaxQueryParser-Thebf_BoostFunctions_Parameter\">More information.</a></ul>", required=false) String bf, @QueryParam(value="sow") @ApiParam(name="sow", value="The sow Parameter: Split on whitespace: if set to false, whitespace-separated term sequences will be provided to text analysis in one shot, enabling proper function of analysis filters that operate over term sequences, e.g. multi-word synonyms and shingles. Defaults to true: text analysis is invoked separately for each individual whitespace-separated term.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-ThesowParameter\">More information.</a></ul>", required=false) String sow, @QueryParam(value="mm.autoRelax") @ApiParam(name="mm.autoRelax", value="If true, the number of clauses required (minimum should match) will automatically be relaxed if a clause is removed (by e.g. stopwords filter) from some but not all qf fields. Use this parameter as a workaround if you experience that queries return zero hits due to uneven stopword removal between the qf fields.<p>Note that relaxing mm may cause undesired side effects, hurting the precision of the search, depending on the nature of your index content.\n<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-Themm.autoRelaxParameter\">More information.</a></ul>", required=false) String mmAutoRelax, @QueryParam(value="boost") @ApiParam(name="boost", value="A multivalued list of strings parsed as queries with scores multiplied by the score from the main query for all matching documents. This parameter is shorthand for wrapping the query produced by eDisMax using the BoostQParserPlugin.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-TheboostParameter\">More information.</a></ul>", required=false) String boost, @QueryParam(value="lowercaseOperators") @ApiParam(name="lowercaseOperators", value="A Boolean parameter indicating if lowercase \"and\" and \"or\" should be treated the same as operators \"AND\" and \"OR\".<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-ThelowercaseOperatorsParameter\">More information.</a></ul>", required=false) String lowercaseOperators, @QueryParam(value="pf2") @ApiParam(name="pf2", value="A multivalued list of fields with optional weights, based on pairs of word shingles.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-Thepf2Parameter\">More information.</a></ul>", required=false) String pf2, @QueryParam(value="ps2") @ApiParam(name="ps2", value="This is similar to ps but overrides the slop factor used for pf2. If not specified, ps is used.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-Theps2Parameter\">More information.</a></ul>", required=false) String ps2, @QueryParam(value="pf3") @ApiParam(name="pf3", value="A multivalued list of fields with optional weights, based on triplets of word shingles. Similar to pf, except that instead of building a phrase per field out of all the words in the input, it builds a set of phrases for each field out of each triplet of word shingles.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-Thepf3Parameter\">More information.</a></ul>", required=false) String pf3, @QueryParam(value="ps3") @ApiParam(name="ps3", value="This is similar to ps but overrides the slop factor used for pf3. If not specified, ps is used.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-Theps3Parameter\">More information.</a></ul>", required=false) String ps3, @QueryParam(value="stopwords") @ApiParam(name="stopwords", value="A Boolean parameter indicating if the StopFilterFactory configured in the query analyzer should be respected when parsing the query: if it is false, then the StopFilterFactory in the query analyzer is ignored.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-ThestopwordsParameter\">More information.</a></ul>", required=false) String stopwords, @QueryParam(value="uf") @ApiParam(name="uf", value="Specifies which schema fields the end user is allowed to explicitly query. This parameter supports wildcards. The default is to allow all fields, equivalent to uf=*. To allow only title field, use uf=title. To allow title and all fields ending with '_s', use uf=title,*_s. To allow all fields except title, use uf=*,-title. To disallow all fielded searches, use uf=-*.<p><a href=\"https://lucene.apache.org/solr/guide/6_6/the-extended-dismax-query-parser.html#TheExtendedDisMaxQueryParser-TheufParameter\">More information.</a></ul>", required=false) String uf, @QueryParam(value="assetTypes") @ApiParam(name="assetTypes", value="Specifies which CM types should be returned when querying 'smarts_feature' index. Should be expressed with pipe separating values. Valid values include: module, package, dataset2,uploadedFile, and dataSourceSchema. By default, all values will be included.E.g. module|package|uploadedFile ", required=false) String assetTypes) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        SolrQueryParameters qp = new SolrQueryParameters("q", query, "defType", defType, "sort", sort, "start", start, "rows", rows, "fq", fq, "fl", fl, "q.alt", qAlt, "qf", qf, "mm", mm, "pf", pf, "ps", ps, "qs", qs, "tie", tie, "bq", bq, "bf", bf, "sow", sow, "mm.autoRelax", mmAutoRelax, "boost", boost, "lowercaseOperators", lowercaseOperators, "pf2", pf2, "ps2", ps2, "pf3", pf3, "ps3", ps3, "stopwords", stopwords, "uf", uf, "assetTypes", assetTypes);
        return this.callTask(new SelectQueryTask((BaseHandler)this, collectionId, qp, locale));
    }
}

