/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.select.tasks;

import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.common.QueryResult;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.handlers.select.tasks.SelectTask;
import java.util.List;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;

public class SelectQueryTask
extends SelectTask {
    static final int READONLY_GET_MAX_AGE = 86400;

    public SelectQueryTask(BaseHandler handler, String collectionId, SolrQueryParameters qp, List<String> locale) {
        super(handler, collectionId, qp, locale);
    }

    @Override
    protected Response executeTask() {
        this.saveRequestContext();
        QueryResult result = this.runQuery();
        return this.buildResponse(this.createCacheableGetResponse(result.toString()));
    }

    protected Response.ResponseBuilder createCacheableGetResponse(String result) {
        Response.ResponseBuilder builder = Response.ok((Object)result);
        CacheControl cc = this.createCacheControl();
        return builder.cacheControl(cc);
    }

    private CacheControl createCacheControl() {
        CacheControl cc = new CacheControl();
        cc.setNoTransform(false);
        if (this.isStaticIndex()) {
            cc.setMaxAge(86400);
            cc.setSMaxAge(86400);
        } else {
            cc.setMustRevalidate(true);
        }
        return cc;
    }
}

