/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.select.tasks;

import com.ibm.bi.search.async.Task;
import com.ibm.bi.search.handlers.collections.CollectionsController;
import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.common.BaseTask;
import com.ibm.bi.search.handlers.common.QueryResult;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class SelectTask
extends BaseTask {
    static final Set<String> READ_ONLY_COLLECTIONS = new HashSet<String>(Arrays.asList("smarts_clue", "smarts_clue_fr", "smarts_clue_es", "smarts_data_clue", "smarts_onto_version"));
    private final CollectionsController controller = new CollectionsController();
    private final String collectionId;
    private final SolrQueryParameters qp;
    private final List<String> locale;

    protected SelectTask(BaseHandler handler, String collectionId, SolrQueryParameters qp, List<String> locale) {
        super(handler, Task.Type.READ_ONLY, false);
        this.collectionId = collectionId;
        this.qp = qp;
        this.locale = locale;
    }

    protected QueryResult runQuery(String query) {
        this.qp.put("q", query);
        return this.runQuery();
    }

    protected QueryResult runQuery() {
        return this.controller.query(this.collectionId, this.qp, this.locale);
    }

    protected boolean isStaticIndex() {
        return StringUtils.isNotEmpty((String)this.collectionId) && READ_ONLY_COLLECTIONS.contains(this.collectionId);
    }
}

