/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.handlers.suggest;

import com.ibm.bi.search.handlers.common.BaseHandler;
import com.ibm.bi.search.handlers.common.HideInternal;
import com.ibm.bi.search.handlers.common.SuggestQueryParameters;
import com.ibm.bi.search.handlers.suggest.SuggestTask;
import com.ibm.bi.search.util.RESTHelper;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/suggest")
@Api(value="/suggest", description="")
public class SuggestHandler
extends BaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public SuggestHandler() {
        this(new RESTHelper());
    }

    protected SuggestHandler(RESTHelper restHelper) {
        super(restHelper);
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @GET
    @Path(value="/{indexId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Return suggestions for the search string", notes="Return search suggestions for the string the user has typed in.", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public Response get(@PathParam(value="indexId") @ApiParam(name="indexId", value="The index the operation is performed in.", required=true) String indexId, @QueryParam(value="term") @ApiParam(name="term", value="The term to get suggestions for.", required=false) String term, @QueryParam(value="filter") @ApiParam(name="filter", value="The field in the index and a list of allowed values for that field that will be used to limit the suggestion results. The first value in the array is the name of the field, while the rest are the values. More than one such parameter can be defined. Values are separated with '|'. ", required=false) List<String> filters, @QueryParam(value="ancestors") @ApiParam(name="ancestors", value="The storeIDs of one or more ancestors as an additional filter to the query. Only documents located under these ancestors (including descendants) will be returned in the results. The storeID values must be separated with '|' characters.") String ancestors, @QueryParam(value="hide_internal") @ApiParam(name="hide_internal", value="Controls whether the internal objects should show up in the search results. Valid values are 'all', 'default' and 'none'. 'all' means hiding all internal objects, 'default' means only hiding objects under the accounts of other users, 'none' means to hide nothing. When nothing is specified 'default' is assumed.", required=false) String hideInternal) {
        this.logRequest(this.httpServletRequest, this.uriInfo);
        SuggestQueryParameters qp = new SuggestQueryParameters();
        qp.setIndexId(indexId);
        qp.setQueryTerm(term);
        qp.setFilters(filters);
        qp.setAncestors(ancestors);
        qp.setHideInternal(HideInternal.parse(hideInternal));
        return this.callTask(SuggestTask.create(this, qp));
    }
}

