/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.healthcheck;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.annotation.Async;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.SearchService;
import com.ibm.bi.search.common.SearchException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

@Async(period=30L, scheduleType=Async.ScheduleType.FIXED_DELAY, initialState=Async.InitialState.HEALTHY, initialDelay=600L)
public class SearchHealthCheck
extends HealthCheck {
    protected HealthCheck.Result check() throws Exception {
        HealthCheck.ResultBuilder builder = HealthCheck.Result.builder();
        if (this.searchServiceAvailable() && this.isSearchServiceHealthy(builder)) {
            return builder.healthy().withMessage("Search-Service is healthy!").build();
        }
        return builder.unhealthy().withMessage("Search-Service is not healthy!").build();
    }

    boolean isSearchServiceHealthy(HealthCheck.ResultBuilder builder) {
        boolean healthy = true;
        try {
            this.addCollections(builder);
        }
        catch (SearchException e) {
            healthy = false;
            builder.withDetail("error", (Object)e.getMessage());
        }
        return healthy;
    }

    void addCollections(HealthCheck.ResultBuilder builder) {
        List<String> collections = this.getSolrCollections();
        if (CollectionUtils.isNotEmpty(collections)) {
            JsonArray colls = new JsonArray();
            for (String collName : collections) {
                if (this.getCollection(collName) != null) {
                    colls.add((Object)new JsonObject().set(collName, (Object)"available"));
                    continue;
                }
                colls.add((Object)new JsonObject().set(collName, (Object)"unknown"));
            }
            builder.withDetail("collections", (Object)colls);
        }
    }

    JsonObject getCollection(String name) {
        return SearchService.getCollectionsController().getCollection(name);
    }

    List<String> getSolrCollections() {
        return SearchService.getCollectionsController().getCollectionsList();
    }

    boolean searchServiceAvailable() {
        return SearchService.isAvailable();
    }
}

