/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.SearchService;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.constants.SchemaProperties;
import com.ibm.bi.search.handlers.common.QueryResult;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.indexing.solr.SchemaUpdateFactory;
import com.ibm.bi.search.indexing.solr.SolrDocumentComparator;
import com.ibm.bi.search.indexing.solr.SolrDocumentCreator;
import com.ibm.bi.search.indexing.solr.SolrHandler;
import com.ibm.bi.search.indexing.solr.SolrJ;
import com.ibm.bi.search.indexing.solr.SolrQueryFactory;
import com.ibm.bi.search.indexing.solr.SolrRequestFactory;
import com.ibm.bi.search.indexing.solr.SolrResponseProcessor;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolrHandler
implements SolrHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CM = IndexNames.CM.toString();
    private static final int CLUES_CACHE_LIMIT = 150;
    private static Set<String> missingCluesCache = ConcurrentHashMap.newKeySet();
    static final SchemaRequest.UniqueKey UNIQUE_KEY_REQUEST = new SchemaRequest.UniqueKey();
    static final SchemaRequest.Fields FIELDS_REQUEST = new SchemaRequest.Fields();
    static final SchemaRequest.FieldTypes FIELD_TYPES_REQUEST = new SchemaRequest.FieldTypes();
    static final SchemaRequest.CopyFields COPY_FIELDS_REQUEST = new SchemaRequest.CopyFields();
    static final SchemaRequest.DynamicFields DYNAMIC_FIELDS_REQUEST = new SchemaRequest.DynamicFields();
    static final List<String> SMARTS_STATIC_INDICES = Collections.unmodifiableList(Arrays.asList(IndexNames.SMARTS_CLUE.toString(), IndexNames.SMARTS_CLUE_ES.toString(), IndexNames.SMARTS_CLUE_FR.toString(), IndexNames.SMARTS_DATA_CLUE.toString(), IndexNames.SMARTS_ONTO_VERSION.toString()));
    private SolrJ solrj;
    private final SolrResponseProcessor responseProcessor;
    private final SolrRequestFactory requestFactory;
    private final SolrQueryFactory queryFactory;
    private final SchemaUpdateFactory updateFactory;

    protected AbstractSolrHandler() {
        this(new SolrResponseProcessor(), new SolrRequestFactory(), new SolrQueryFactory(), new SchemaUpdateFactory());
    }

    protected AbstractSolrHandler(SolrResponseProcessor responseProcessor, SolrRequestFactory requestFactory, SolrQueryFactory queryFactory, SchemaUpdateFactory updateFactory) {
        this.responseProcessor = responseProcessor;
        this.requestFactory = requestFactory;
        this.queryFactory = queryFactory;
        this.updateFactory = updateFactory;
    }

    protected SolrResponseProcessor getResponseProcessor() {
        return this.responseProcessor;
    }

    protected SolrRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    protected SolrQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    protected SchemaUpdateFactory getUpdateFactory() {
        return this.updateFactory;
    }

    protected SolrJ getSolrJ() {
        if (this.solrj == null) {
            this.solrj = new SolrJ(this.getSolrClient(), this.getResponseProcessor(), this.getRequestFactory());
        }
        return this.solrj;
    }

    protected void validateCMSchemaVersion() {
        if (this.collectionExists(CM)) {
            JsonObject cmSchemaInfo = this.getSolrJ().getSchemaInfo(CM);
            String indexSearchVersion = cmSchemaInfo.getString(SchemaProperties.SEARCH_VERSION.toString());
            String currentSearchVersion = SearchService.getVersion();
            if (!currentSearchVersion.equals(indexSearchVersion)) {
                LOG.debug("Deleting CM index due to Search Version Mismatch: Was: {} Expected: {}", (Object)indexSearchVersion, (Object)currentSearchVersion);
                this.deleteCores(IndexNames.CM, IndexNames.MO, IndexNames.SMARTS_FEATURE, IndexNames.POLICIES);
            }
        }
    }

    private void deleteCores(IndexNames ... indexNames) {
        List<String> existingCores = this.getCores();
        for (IndexNames indexName : indexNames) {
            this.deleteIfFound(indexName.toString(), existingCores);
        }
    }

    private void deleteIfFound(String coreName, List<String> existingCores) {
        if (existingCores.contains(coreName)) {
            this.deleteCore(coreName);
        }
    }

    private void addToClueCache(String key) {
        if (missingCluesCache.size() < 150) {
            LOG.debug("Adding '{}' to solr smarts clue cache.", (Object)key);
            missingCluesCache.add(key);
        }
    }

    static boolean isInMissingCluesCache(String coreName) {
        return missingCluesCache.contains(coreName);
    }

    static void setMissingCluesCacheForTesting(Set<String> clueCache) {
        missingCluesCache = clueCache;
    }

    protected String getSchemaNameAndFailIfInvalid(JsonObject schema) {
        String collectionName = schema.getString(FieldNames.ID.toString());
        if (collectionName == null) {
            LOG.debug("The defined schema must have an id. Please add the 'id' field to the defined schema.");
            throw new SearchException(SearchMessageKeys.FIELD_NULL, FieldNames.ID.toString());
        }
        return collectionName;
    }

    protected void checkIfCollectionAlreadyExists(String collectionName) {
        if (this.collectionExists(collectionName)) {
            throw new SearchException(SearchMessageKeys.INDEX_ALREADY_EXISTS, collectionName, 409);
        }
    }

    private static boolean isSmartsStaticCollection(String collectionName) {
        return !IndexNames.SMARTS_FEATURE.toString().equals(collectionName);
    }

    private static boolean isCMIndex(String collectionName) {
        return CM.equals(collectionName);
    }

    protected boolean collectionExists(String collectionName) {
        return this.getCores().contains(collectionName);
    }

    protected void throw404IfNotFound(String collectionName) {
        if (!this.collectionExists(collectionName)) {
            throw new SearchException(SearchMessageKeys.UNKNOWN_INDEX, collectionName, 404);
        }
    }

    protected void updateConfigSet(JsonObject schema, String collectionName) {
        this.updateCollection(collectionName, schema);
        this.updateCMSchemaProperties(collectionName, schema);
    }

    private void updateCollection(String collectionName, JsonObject schema) {
        List<SchemaRequest.Update> updates = this.getUpdateFactory().createUpdates(schema);
        if (!updates.isEmpty()) {
            this.getSolrJ().updateSchema(collectionName, updates);
        }
    }

    private void updateCMSchemaProperties(String collectionName, JsonObject schema) {
        if (AbstractSolrHandler.isCMIndex(collectionName)) {
            String cmInstance = schema.getString(SchemaProperties.INSTANCE.toString());
            String cmVersion = schema.getString(SchemaProperties.VERSION.toString());
            this.getSolrJ().createCMSchema(collectionName, cmInstance, cmVersion);
        }
    }

    @Override
    public void addDocument(String collectionName, JsonObject document) {
        this.addDocuments(collectionName, new JsonArray(new Object[]{document}));
    }

    @Override
    public void addDocuments(String collectionName, JsonArray documents) {
        try {
            for (Object document : documents) {
                SolrInputDocument solrDocument = new SolrDocumentCreator(collectionName, (JsonObject)document).create();
                this.getSolrJ().add(collectionName, solrDocument);
            }
            this.softCommit(collectionName);
        }
        catch (Exception e) {
            this.throw404IfNotFound(collectionName);
            throw SearchException.wrap(e, "An error occurred adding documents to the collection: " + collectionName, new Object[0]);
        }
    }

    @Override
    public void updateDocument(String collectionName, JsonObject document) {
        this.deleteDocument(collectionName, document.getString(FieldNames.ID.toString()));
        this.addDocument(collectionName, document);
    }

    @Override
    public void updateDocuments(String collectionName, List<SolrInputDocument> documents) {
        try {
            for (SolrInputDocument document : documents) {
                this.getSolrJ().add(collectionName, document);
            }
            this.softCommit(collectionName);
        }
        catch (Exception e) {
            this.throw404IfNotFound(collectionName);
            throw SearchException.wrap(e, "An error occurred updating documents in the collection: " + collectionName, new Object[0]);
        }
    }

    @Override
    public void deleteDocument(String collectionName, String documentId) {
        try {
            this.getSolrJ().deleteById(collectionName, documentId);
            this.softCommit(collectionName);
        }
        catch (Exception e) {
            this.throw404IfNotFound(collectionName);
            throw SearchException.wrap(e, "An error occurred deleting document %s from the collection %s", documentId, collectionName);
        }
    }

    @Override
    public void deleteDocumentsByQuery(String collectionName, String query) {
        try {
            this.getSolrJ().deleteByQuery(collectionName, query);
            this.softCommit(collectionName);
        }
        catch (Exception e) {
            this.throw404IfNotFound(collectionName);
            throw SearchException.wrap(e, "An error occurred deleting documents by query from the collection: " + collectionName, new Object[0]);
        }
    }

    @Override
    public JsonObject getCore(String collectionName) {
        if (!this.collectionExists(collectionName)) {
            if (!AbstractSolrHandler.isCMIndex(collectionName)) {
                this.throw404IfNotFound(collectionName);
            }
            return new JsonObject();
        }
        JsonObject collectionInfo = new JsonObject();
        collectionInfo.put(collectionName, (Object)this.getCoreInformation(collectionName));
        return collectionInfo;
    }

    private JsonObject getCoreInformation(String collectionName) {
        JsonObject config = new JsonObject();
        config.put(SchemaProperties.SCHEMA.toString(), (Object)this.getCoreSchemaObject(collectionName));
        return config;
    }

    private JsonObject getCoreSchemaObject(String collectionName) {
        JsonObject schema = new JsonObject();
        schema.put(SchemaProperties.UNIQUE_KEY.toString(), (Object)this.getSolrJ().getCollectionUniqueKey(collectionName));
        schema.put(SchemaProperties.FIELDS.toString(), (Object)this.getSolrJ().getCollectionFields(collectionName));
        schema.put(SchemaProperties.FIELD_TYPES.toString(), (Object)this.getSolrJ().getCollectionFieldTypes(collectionName));
        schema.put(SchemaProperties.DYNAMIC_FIELDS.toString(), (Object)this.getSolrJ().getCollectionDynamicFields(collectionName));
        schema.put(SchemaProperties.COPY_FIELDS.toString(), (Object)this.getSolrJ().getCollectionCopyFields(collectionName));
        if (AbstractSolrHandler.isCMIndex(collectionName)) {
            JsonObject cmSchemaInfo = this.getSolrJ().getSchemaInfo(CM);
            schema.put(SchemaProperties.SEARCH_VERSION.toString(), (Object)cmSchemaInfo.getString(SchemaProperties.SEARCH_VERSION.toString()));
            schema.put(SchemaProperties.INSTANCE.toString(), (Object)cmSchemaInfo.getString(SchemaProperties.INSTANCE.toString()));
            schema.put(SchemaProperties.VERSION.toString(), (Object)cmSchemaInfo.getString(SchemaProperties.VERSION.toString()));
        }
        return schema;
    }

    @Override
    public QueryResult query(String coreName, SolrQueryParameters qp) {
        return this.query(coreName, qp, Collections.emptyList());
    }

    @Override
    public QueryResult query(String coreName, SolrQueryParameters qp, List<String> locales) {
        SolrQuery solrQuery = AbstractSolrHandler.isSmartsStaticCollection(coreName) ? this.getQueryFactory().createSolrQuery(qp) : this.getQueryFactory().createSolrSecureQuery(qp);
        List<String> localeCoreNames = this.getLocaleCoreNames(coreName, locales);
        try {
            return this.queryAllCores(coreName, localeCoreNames, solrQuery);
        }
        catch (Exception e) {
            this.throw404IfNotFound(coreName);
            throw SearchException.wrap(e, "An error occurred while executing a query on the collection: " + coreName, new Object[0]);
        }
    }

    private List<String> getLocaleCoreNames(String baseCoreName, List<String> locales) {
        ArrayList<String> coresToQuery = new ArrayList<String>();
        for (String locale : locales) {
            String coreName = StringUtils.join((Object[])new String[]{baseCoreName, "_", locale});
            if (AbstractSolrHandler.isInMissingCluesCache(coreName)) continue;
            coresToQuery.add(coreName);
        }
        return coresToQuery;
    }

    private QueryResult queryAllCores(String defaultCoreName, List<String> localeCoreNames, SolrQuery query) {
        SolrDocumentList queryResults = new SolrDocumentList();
        QueryResponse defaultResponse = this.getSolrJ().query(defaultCoreName, query);
        if (query.getHighlight()) {
            queryResults.addAll((Collection)this.getExtendedResultWithHighlighting(defaultResponse));
        } else {
            queryResults.addAll((Collection)defaultResponse.getResults());
        }
        queryResults.addAll((Collection)this.queryLocaleCores(localeCoreNames, query));
        queryResults.sort((Comparator)new SolrDocumentComparator());
        return new QueryResult(queryResults, defaultResponse.getHeader(), query);
    }

    private SolrDocumentList queryLocaleCores(List<String> localeCoreNames, SolrQuery query) {
        SolrDocumentList queryResults = new SolrDocumentList();
        for (String coreName : localeCoreNames) {
            try {
                QueryResponse response = this.getSolrJ().query(coreName, query);
                queryResults.addAll((Collection)response.getResults());
            }
            catch (Exception e) {
                LOG.warn("The collection with name: " + coreName + " was requested but doesn't exist based on its locale extension.", (Throwable)e);
                this.addToClueCache(coreName);
            }
        }
        return queryResults;
    }

    private SolrDocumentList getExtendedResultWithHighlighting(QueryResponse defaultResponse) {
        SolrDocumentList results = defaultResponse.getResults();
        for (SolrDocument result : results) {
            if (result.isEmpty()) continue;
            try {
                this.mapHighlightingToResult(result, defaultResponse.getHighlighting());
            }
            catch (Exception e) {
                LOG.warn("The result with ID: " + result.get((Object)FieldNames.ID.toString()) + " did not return highlighting.", (Throwable)e);
            }
        }
        return results;
    }

    private Map<String, List<String>> getHighlightingMatchingWithResult(SolrDocument result, Map<String, Map<String, List<String>>> highlighting) {
        return highlighting.get(result.get((Object)FieldNames.ID.toString()));
    }

    private void mapHighlightingToResult(SolrDocument result, Map<String, Map<String, List<String>>> highlightingMap) {
        Map<String, List<String>> matchingHighlight = this.getHighlightingMatchingWithResult(result, highlightingMap);
        if (matchingHighlight != null) {
            for (Map.Entry<String, List<String>> entry : matchingHighlight.entrySet()) {
                SolrDocument highlightingDoc = new SolrDocument();
                highlightingDoc.addField(entry.getKey(), entry.getValue());
                result.addField("highlighting", (Object)highlightingDoc);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.getSolrClient().close();
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "An error occurred while attempting to close the Solr server client.", new Object[0]);
        }
    }

    private void softCommit(String collectionName) {
        this.getSolrJ().commit(collectionName, false, false, true);
    }
}

