/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.indexing.solr.AbstractSolrHandler;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudSolrHandler
extends AbstractSolrHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CONFIG_SET_TEMPLATE_FOR_NEW_COLLECTIONS = "_default";
    private static final String NUM_SHARDS_SYS_PROP = "SHARDS";
    private static final String NUM_REPLICAS_SYS_PROP = "REPLICAS";
    private static final int DEFAULT_NUM_SHARDS_PER_COLLECTION = 1;
    private static final int DEFAULT_NUM_REPLICAS_PER_COLLECTION = 1;
    private final String solrServerUrl;
    private SolrClient solrClient;

    public CloudSolrHandler(String solrServerUrl) {
        this.solrServerUrl = solrServerUrl;
    }

    protected CloudSolrHandler(String solrServerUrl, SolrClient solrClient) {
        this(solrServerUrl);
        this.solrClient = solrClient;
    }

    @Override
    public synchronized void initialize() {
        this.validateCMSchemaVersion();
    }

    @Override
    public void cleanInitialize() {
        this.deleteAllCores();
        this.initialize();
    }

    private void deleteAllCores() {
        for (IndexNames index : IndexNames.values()) {
            this.deleteCore(index.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SolrClient getSolrClient() {
        Class<CloudSolrHandler> clazz = CloudSolrHandler.class;
        synchronized (CloudSolrHandler.class) {
            if (this.solrClient == null) {
                this.solrClient = CloudSolrHandler.createSolrClient(this.solrServerUrl);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.solrClient;
        }
    }

    private static LBHttpSolrClient createSolrClient(String serverUrl) {
        LBHttpSolrClient.Builder clientBuilder = new LBHttpSolrClient.Builder();
        return clientBuilder.withBaseSolrUrl(serverUrl).build();
    }

    @Override
    public void createCore(JsonObject schema) {
        String collectionName = this.getSchemaNameAndFailIfInvalid(schema);
        this.checkIfCollectionAlreadyExists(collectionName);
        this.checkIfConfigSetAlreadyExists(collectionName);
        this.createNewConfigSet(collectionName);
        this.createNewCollection(collectionName);
        this.updateConfigSet(schema, collectionName);
    }

    private void createNewConfigSet(String collectionName) {
        this.getSolrJ().createConfigSet(collectionName, CONFIG_SET_TEMPLATE_FOR_NEW_COLLECTIONS);
    }

    private void createNewCollection(String collectionName) {
        this.getSolrJ().createCollection(collectionName, collectionName, this.getNumOfShardsPerCollection(), this.getNumOfReplicasPerCollection());
    }

    protected int getNumOfReplicasPerCollection() {
        return Integer.getInteger(NUM_REPLICAS_SYS_PROP, 1);
    }

    protected int getNumOfShardsPerCollection() {
        return Integer.getInteger(NUM_SHARDS_SYS_PROP, 1);
    }

    private void checkIfConfigSetAlreadyExists(String collectionName) {
        if (this.configSetExists(collectionName)) {
            LOG.debug("Config set is out of sync with {} collection. Deleting config set.", (Object)collectionName);
            this.forceDeleteConfigSet(collectionName);
        }
    }

    private boolean configSetExists(String collectionName) {
        List<String> configSets = this.getSolrJ().listConfigSets();
        return configSets.contains(collectionName);
    }

    @Override
    public List<String> getCores() {
        return this.getSolrJ().listCollections();
    }

    @Override
    public void deleteCore(String collectionName) {
        if (this.collectionExists(collectionName)) {
            this.deleteCollection(collectionName);
            this.deleteConfigSet(collectionName);
        } else {
            this.forceDeleteConfigSet(collectionName);
            this.throw404IfNotFound(collectionName);
        }
    }

    private void deleteCollection(String collectionName) {
        this.getSolrJ().deleteCollection(collectionName);
    }

    private void deleteConfigSet(String collectionName) {
        this.getSolrJ().deleteConfigSet(collectionName);
    }

    private void forceDeleteConfigSet(String collectionName) {
        try {
            this.deleteConfigSet(collectionName);
        }
        catch (Exception e) {
            LOG.trace("Didn't really need to delete config set: {}", (Object)collectionName);
        }
    }

    @Override
    public Date getLastModified(String collectionName) {
        return new Date();
    }

    @Override
    public void close() {
        if (this.solrClient != null) {
            try {
                this.solrClient.close();
            }
            catch (Exception e) {
                throw SearchException.wrap(e, "An error occurred while attempting to close the Solr server client.", new Object[0]);
            }
        }
    }
}

