/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.constants.SchemaProperties;
import com.ibm.bi.search.handlers.common.JSONBuilder;
import com.ibm.bi.search.indexing.solr.SolrHandlerFactory;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionCreator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CM_SOLR_SCHEMA = "/data/cmSolrSchema.json";
    private static final String SMARTS_FEATURE_SOLR_SCHEMA = "/data/featureSchema.json";
    private static final String CM_LANGUAGE_ANALYZERS = "/data/languageAnalyzers.json";
    private static final String POLICIES_SCHEMA = "/data/policiesSchema.json";
    private final SolrHandlerFactory solrFactory;

    public CollectionCreator() {
        this(new SolrHandlerFactory());
    }

    public CollectionCreator(SolrHandlerFactory solrFactory) {
        this.solrFactory = solrFactory;
    }

    public void createCMCollection(String cmInstance, String cmVersion) {
        if (!this.collectionExists(IndexNames.CM.toString())) {
            LOG.trace("Creating CM collection in Solr.");
            JsonObject cmSolrSchema = CollectionCreator.loadSolrSchema(CM_SOLR_SCHEMA);
            cmSolrSchema.set(SchemaProperties.FIELD_TYPES.toString(), (Object)CollectionCreator.loadLanguageAnalyzers(CM_LANGUAGE_ANALYZERS));
            cmSolrSchema.put(SchemaProperties.INSTANCE.toString(), (Object)cmInstance);
            cmSolrSchema.put(SchemaProperties.VERSION.toString(), (Object)cmVersion);
            this.solrFactory.createSolrHandler().createCore(cmSolrSchema);
        }
    }

    public void createSmartsFeatureCollection() {
        if (!this.collectionExists(IndexNames.SMARTS_FEATURE.toString())) {
            LOG.trace("Creating smarts_feature collection in Solr.");
            this.solrFactory.createSolrHandler().createCore(CollectionCreator.loadSolrSchema(SMARTS_FEATURE_SOLR_SCHEMA));
        }
    }

    public void createPoliciesCollection() {
        if (!this.collectionExists(IndexNames.POLICIES.toString())) {
            LOG.trace("Creating policies collection in Solr.");
            this.solrFactory.createSolrHandler().createCore(CollectionCreator.loadSolrSchema(POLICIES_SCHEMA));
        }
    }

    private boolean collectionExists(String collectionId) {
        return this.solrFactory.createSolrHandler().getCores().contains(collectionId);
    }

    private static JsonObject loadSolrSchema(String path) {
        return (JsonObject)JSONBuilder.loadJsonFromFile(CollectionCreator.class, path);
    }

    private static JsonArray loadLanguageAnalyzers(String path) {
        return (JsonArray)JSONBuilder.loadJsonFromFile(CollectionCreator.class, path);
    }
}

