/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.indexing.solr.AbstractSolrHandler;
import com.ibm.bi.search.indexing.solr.CollectionCreator;
import com.ibm.bi.search.indexing.solr.LockBreaker;
import com.ibm.bi.search.indexing.solr.VersionChecker;
import com.ibm.bi.search.indexing.solr.policies.PoliciesCacheFactory;
import com.ibm.bi.search.util.SearchConfig;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedSolrHandler
extends AbstractSolrHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_SOLR_DIR = "default";
    private static final int MAX_RETRIES = 10;
    private static final long SLEEP_BETWEEN_RETRIES = 3000L;
    private static SolrClient solrClient;
    private final PoliciesCacheFactory policiesFactory = new PoliciesCacheFactory();

    @Override
    public synchronized void initialize() {
        if (solrClient == null) {
            this.checkSolrVersion();
            this.reloadSmartsStaticIndices();
            EmbeddedSolrHandler.initializeSolrClient();
            EmbeddedSolrHandler.createPoliciesAndSmartsFeatureCollections();
            this.validateCMSchemaVersion();
        }
    }

    @Override
    public synchronized void cleanInitialize() {
        EmbeddedSolrHandler.shutdown();
        this.deleteAllCollectionsInConfigCollectionsDirectory();
        this.initialize();
    }

    protected void deleteAllCollectionsInConfigCollectionsDirectory() {
        File collectionsDirectory = new File(SearchConfig.getCollectionsDirectory());
        EmbeddedSolrHandler.deleteCollectionsDirectory(collectionsDirectory);
        if (!EmbeddedSolrHandler.recreateCollectionsDirectory(collectionsDirectory)) {
            throw new SearchException(SearchMessageKeys.INTERNAL_ERROR, "Failed to create collections directory");
        }
    }

    private static boolean recreateCollectionsDirectory(File collectionsDirectory) {
        boolean collectionsDirectoryMade = collectionsDirectory.mkdir();
        for (int i = 0; i < 10 && !collectionsDirectoryMade; ++i) {
            try {
                LOG.debug("Tried to create collections directory, waiting and retying...");
                Thread.sleep(3000L);
                collectionsDirectoryMade = collectionsDirectory.mkdir();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw SearchException.wrap((Exception)e, "Interrupted while waiting to create collections directory", new Object[0]);
            }
        }
        return collectionsDirectoryMade;
    }

    private static void deleteCollectionsDirectory(File directory) {
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "Failed to delete directory", new Object[0]);
        }
    }

    private void checkSolrVersion() {
        VersionChecker versionChecker = new VersionChecker(SearchConfig.getCollectionsDirectory(), SearchConfig.getProductConfigDirectory());
        versionChecker.enforceSolrVersion();
    }

    private static void initializeSolrClient() {
        EmbeddedSolrHandler.breakIndexLocks();
        solrClient = new EmbeddedSolrServer(EmbeddedSolrHandler.createContainer(EmbeddedSolrHandler.getSolrHome()), DEFAULT_SOLR_DIR);
    }

    private static void breakIndexLocks() {
        new LockBreaker().breakIndexLocks();
    }

    private static CoreContainer createContainer(String containerPath) {
        Path path = Paths.get(containerPath, new String[0]);
        return CoreContainer.createAndLoad((Path)path);
    }

    private static String getSolrHome() {
        return EmbeddedSolrHandler.toFullPath(SearchConfig.getCollectionsDirectory());
    }

    private static String toFullPath(String pathName) {
        try {
            FileUtils.forceMkdir((File)new File(pathName));
            return Paths.get(pathName, new String[0]).toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            throw SearchException.wrap((Exception)e, "Invalid path: " + pathName, new Object[0]);
        }
    }

    private static void copySolrXmlTo(String solrHome) {
        try {
            String solrXml = "solr.xml";
            String source = Paths.get(EmbeddedSolrHandler.getConfigCollectionsDirectory(), solrXml).toString();
            String destination = Paths.get(solrHome, solrXml).toString();
            LOG.debug("Copying solr config from {} to {}", (Object)source, (Object)destination);
            FileUtils.copyFile((File)new File(source), (File)new File(destination));
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "Failed to copy solr config to " + solrHome, new Object[0]);
        }
    }

    private static void copyStaticCollectionsTo(String destination) {
        try {
            String source = SearchConfig.getStaticCollectionsDirectory();
            LOG.debug("Copying static collections from {} to {}", (Object)source, (Object)destination);
            FileUtils.copyDirectory((File)new File(source), (File)new File(destination));
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "Failed to copy static collections to " + destination, new Object[0]);
        }
    }

    private static String getConfigCollectionsDirectory() {
        return SearchConfig.getProductConfigDirectory() + "/collections";
    }

    private static void createPoliciesAndSmartsFeatureCollections() {
        CollectionCreator creator = new CollectionCreator();
        creator.createSmartsFeatureCollection();
        creator.createPoliciesCollection();
    }

    static void deleteCollectionInConfigCollectionsDirectory(String collection) {
        try {
            String collectionPath = Paths.get(EmbeddedSolrHandler.getConfigCollectionsDirectory(), collection).toString();
            FileUtils.deleteDirectory((File)new File(collectionPath));
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "Failed to delete collection: " + collection, new Object[0]);
        }
    }

    static String getOntoVersionFromClient(SolrClient client) throws SolrServerException, IOException {
        SolrQuery query = EmbeddedSolrHandler.createSmartsVersionQuery();
        SolrDocumentList result = client.query(IndexNames.SMARTS_ONTO_VERSION.toString(), (SolrParams)query).getResults();
        return EmbeddedSolrHandler.getVersionFromResult((SolrDocument)result.get(0));
    }

    private static SolrQuery createSmartsVersionQuery() {
        SolrQuery query = new SolrQuery();
        query.add("defType", new String[]{"edismax"});
        query.add("q", new String[]{"*"});
        query.add("fl", new String[]{FieldNames.VERSION.toString()});
        query.add("rows", new String[]{"1"});
        return query;
    }

    private static String getVersionFromResult(SolrDocument result) {
        if (result != null && result.get((Object)FieldNames.VERSION.toString()) != null) {
            return result.get((Object)FieldNames.VERSION.toString()).toString();
        }
        return null;
    }

    private void reloadSmartsStaticIndices() {
        this.deleteExistingSmartsIndices();
        EmbeddedSolrHandler.copySolrXmlTo(SearchConfig.getCollectionsDirectory());
        EmbeddedSolrHandler.copyStaticCollectionsTo(SearchConfig.getCollectionsDirectory());
    }

    private void deleteExistingSmartsIndices() {
        for (String indexName : SMARTS_STATIC_INDICES) {
            LOG.debug("Deleting: {}", (Object)indexName);
            try {
                FileUtils.deleteDirectory((File)EmbeddedSolrHandler.getIndexDirectory(indexName));
            }
            catch (Exception e) {
                throw SearchException.wrap(e, "Failed to delete smart index: " + indexName, new Object[0]);
            }
        }
    }

    private static File getIndexDirectory(String indexName) {
        return new File(SearchConfig.getCollectionsDirectory() + "/" + indexName);
    }

    private static void closeSolrClient() {
        try {
            solrClient.close();
        }
        catch (Exception e) {
            LOG.debug("Failed to close the solr client.", (Throwable)e);
        }
    }

    @Override
    public SolrClient getSolrClient() {
        return solrClient;
    }

    @Override
    public void close() {
    }

    @Override
    public void createCore(JsonObject schema) {
        String coreName = this.getSchemaNameAndFailIfInvalid(schema);
        this.checkIfCollectionAlreadyExists(coreName);
        EmbeddedSolrHandler.createNewConfigSet(coreName);
        this.createNewCollection(coreName);
        this.updateConfigSet(schema, coreName);
    }

    private static void createNewConfigSet(String coreName) {
        try {
            String source = EmbeddedSolrHandler.getConfigPath(coreName);
            String destination = EmbeddedSolrHandler.getSolrHome() + "/" + coreName;
            LOG.debug("Copying config set template from {} to {}", (Object)source, (Object)destination);
            FileUtils.copyDirectory((File)new File(source), (File)new File(destination));
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "An error occurred while creating an embedded core:" + coreName, new Object[0]);
        }
    }

    private static String getConfigPath(String coreName) {
        return String.format("%s/config/configsets/%s_configs", SearchConfig.getProductConfigDirectory(), coreName.equals(IndexNames.SMARTS_FEATURE.toString()) ? coreName : "basic");
    }

    private void createNewCollection(String coreName) {
        this.getSolrJ().createCore(coreName);
    }

    @Override
    public void deleteCore(String coreName) {
        this.throw404IfNotFound(coreName);
        this.deleteStorage(coreName);
        this.getSolrJ().deleteCore(coreName);
    }

    private void deleteStorage(String coreName) {
        if (coreName.equals(IndexNames.POLICIES.toString())) {
            LOG.debug("Deleting storage for {}.", (Object)coreName);
            this.policiesFactory.getPoliciesCache().deleteStorage();
        }
    }

    @Override
    public List<String> getCores() {
        return this.getSolrJ().listCores();
    }

    @Override
    public Date getLastModified(String coreName) {
        return this.getSolrJ().getLastModified(coreName);
    }

    public static synchronized void shutdown() {
        if (solrClient != null) {
            EmbeddedSolrHandler.closeSolrClient();
            solrClient = null;
        }
        EmbeddedSolrHandler.breakIndexLocks();
    }

    public static boolean isAvailable() {
        return solrClient != null;
    }
}

