/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.util.SearchConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockBreaker {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String LOCK_EXTENSION = ".lock";
    private static final String INDEX_FOLDER_PATH = Paths.get("data", "index").toString();
    private static FilenameFilter folderFilter = (dir, name) -> new File(dir, name).isDirectory();
    private static FilenameFilter lockFilter = (dir, name) -> name.toLowerCase().endsWith(LOCK_EXTENSION);
    private File baseDirectory;

    public LockBreaker() {
        this.baseDirectory = new File(SearchConfig.getCollectionsDirectory());
    }

    protected LockBreaker(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void breakIndexLocks() {
        LOG.debug("Deleting lock files");
        File[] solrCollections = this.baseDirectory.listFiles(folderFilter);
        if (solrCollections != null) {
            for (File collection : solrCollections) {
                LockBreaker.deleteLockFromCollectionIfExists(collection);
            }
        }
    }

    private static void deleteLockFromCollectionIfExists(File collection) {
        File indexDir = Paths.get(collection.getPath(), INDEX_FOLDER_PATH).toFile();
        File[] locks = indexDir.listFiles(lockFilter);
        if (locks == null || locks.length == 0) {
            LOG.debug("There were no locks at {}", (Object)collection.getPath());
            return;
        }
        for (File lock : locks) {
            LockBreaker.forceDeleteLock(lock);
        }
    }

    static void forceDeleteLock(File lock) {
        try {
            FileUtils.forceDelete((File)lock);
            LOG.debug("Deleted lock {}", (Object)lock.getPath());
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "Failed to force delete lock: %s", lock);
        }
    }
}

