/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.SchemaProperties;
import com.ibm.bi.search.indexing.solr.SolrRequestFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;

public class SchemaUpdateFactory {
    private final SolrRequestFactory requestFactory;

    public SchemaUpdateFactory() {
        this(new SolrRequestFactory());
    }

    protected SchemaUpdateFactory(SolrRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public List<SchemaRequest.Update> createUpdates(JsonObject schema) {
        ArrayList<SchemaRequest.Update> updates = new ArrayList<SchemaRequest.Update>();
        updates.addAll(this.createFieldTypes(schema));
        updates.addAll(this.createDynamicFields(schema));
        updates.addAll(this.createFields(schema));
        updates.addAll(this.createCopyFields(schema));
        return updates;
    }

    private List<SchemaRequest.Update> createFieldTypes(JsonObject schema) {
        ArrayList<SchemaRequest.Update> updates = new ArrayList<SchemaRequest.Update>();
        JsonArray fieldTypes = schema.getArray(SchemaProperties.FIELD_TYPES.toString());
        if (this.isNotEmpty(fieldTypes)) {
            for (Object o : fieldTypes) {
                JsonObject fieldType = (JsonObject)o;
                updates.add((SchemaRequest.Update)this.createFieldType(fieldType));
            }
        }
        return updates;
    }

    private boolean isNotEmpty(JsonArray ja) {
        return ja != null && !ja.isEmpty();
    }

    private SchemaRequest.AddFieldType createFieldType(JsonObject fieldType) {
        return this.getRequestFactory().createAddFieldTypeRequest(fieldType);
    }

    private List<SchemaRequest.Update> createDynamicFields(JsonObject schema) {
        ArrayList<SchemaRequest.Update> updates = new ArrayList<SchemaRequest.Update>();
        JsonArray dynamicFields = schema.getArray(SchemaProperties.DYNAMIC_FIELDS.toString());
        if (this.isNotEmpty(dynamicFields)) {
            for (Object o : dynamicFields) {
                JsonObject dynamicField = (JsonObject)o;
                updates.add((SchemaRequest.Update)this.addDynamicField(dynamicField));
            }
        }
        return updates;
    }

    private SchemaRequest.AddDynamicField addDynamicField(JsonObject dynamicField) {
        return this.getRequestFactory().createAddDynamicFieldRequest(dynamicField);
    }

    private List<SchemaRequest.Update> createFields(JsonObject schema) {
        ArrayList<SchemaRequest.Update> updates = new ArrayList<SchemaRequest.Update>();
        JsonArray fields = (JsonArray)schema.get(SchemaProperties.FIELDS.toString());
        if (this.isNotEmpty(fields)) {
            for (Object o : fields) {
                JsonObject field = (JsonObject)o;
                updates.add((SchemaRequest.Update)this.addField(field));
            }
        }
        return updates;
    }

    private SchemaRequest.AddField addField(JsonObject field) {
        return this.getRequestFactory().createAddFieldRequest(field);
    }

    private List<SchemaRequest.Update> createCopyFields(JsonObject schema) {
        ArrayList<SchemaRequest.Update> updates = new ArrayList<SchemaRequest.Update>();
        JsonArray copyFields = schema.getArray(SchemaProperties.COPY_FIELDS.toString());
        if (this.isNotEmpty(copyFields)) {
            for (Object copyField : copyFields) {
                updates.add((SchemaRequest.Update)this.updateCopyField((JsonObject)copyField));
            }
        }
        return updates;
    }

    private SchemaRequest.AddCopyField updateCopyField(JsonObject copyField) {
        return this.getRequestFactory().createAddCopyFieldRequest(copyField);
    }

    protected SolrRequestFactory getRequestFactory() {
        return this.requestFactory;
    }
}

