/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.constants.ObjectTypes;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrInputDocument;

public class SolrDocumentCreator {
    private final String collectionId;
    private final JsonObject document;

    public SolrDocumentCreator(String collectionId, JsonObject document) {
        this.collectionId = collectionId;
        this.document = document;
    }

    public SolrInputDocument create() {
        SolrInputDocument solrDocument = new SolrInputDocument(new String[0]);
        for (Map.Entry field : this.document.entrySet()) {
            if (FieldNames.OWNER.toString().equals(field.getKey())) {
                SolrDocumentCreator.attachUserIDAndOwner(this.collectionId, solrDocument, (String)field.getValue());
                continue;
            }
            if (SolrDocumentCreator.isTenantPublic(field)) {
                solrDocument.setField((String)field.getKey(), (Object)"publictenant");
                continue;
            }
            if (SolrDocumentCreator.isContentOfModule(field, this.document.getString(FieldNames.TYPE.toString()))) {
                solrDocument.setField((String)field.getKey(), (Object)"");
                continue;
            }
            if (solrDocument.containsKey(field.getKey()) || FieldNames.PERMISSIONS.toString().equals(field.getKey())) continue;
            solrDocument.setField((String)field.getKey(), field.getValue());
        }
        return solrDocument;
    }

    private static void attachUserIDAndOwner(String collectionName, SolrInputDocument solrDocument, String value) {
        if (value != null) {
            String valueLC = value.toLowerCase();
            solrDocument.setField(FieldNames.USER_ID.toString(), (Object)valueLC);
            if (collectionName.equals(IndexNames.CM.toString()) || collectionName.equals(IndexNames.POLICIES.toString())) {
                solrDocument.setField(FieldNames.OWNER.toString(), (Object)value);
            }
        }
    }

    private static boolean isTenantPublic(Map.Entry<String, Object> field) {
        return FieldNames.TENANT_ID.toString().equals(field.getKey()) && StringUtils.isEmpty((String)((String)field.getValue()));
    }

    private static boolean isContentOfModule(Map.Entry<String, Object> field, String documentType) {
        return FieldNames.CONTENT.toString().equals(field.getKey()) && SolrDocumentCreator.isModuleOrBaseModule(documentType);
    }

    private static boolean isModuleOrBaseModule(String type) {
        return ObjectTypes.MODULE.toString().equals(type) || ObjectTypes.BASE_MODULE.toString().equals(type);
    }
}

