/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.handlers.common.HideInternal;
import com.ibm.bi.search.handlers.common.QueryResult;
import com.ibm.bi.search.handlers.common.SearchQueryParameters;
import com.ibm.bi.search.indexing.solr.SolrHandlerFactory;
import com.ibm.bi.search.solr.query.SearchQueryBuilder;
import com.ibm.bi.search.util.SearchConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SolrDocumentSecurityFilter {
    private final SolrHandlerFactory solrFactory;
    private final SearchQueryParameters qp;
    private static final String DEFAULT_ASSET_TYPES_FILTER = "type|uploadedFile|package|dataset2|module|dataSourceSchema";
    private static final int MAX_NUMBER_OF_ASSET_REFS = SearchConfig.getCmAssetQueryResults();

    public SolrDocumentSecurityFilter() {
        this(new SolrHandlerFactory(), new SearchQueryParameters());
    }

    protected SolrDocumentSecurityFilter(SolrHandlerFactory solrFactory, SearchQueryParameters qp) {
        this.solrFactory = solrFactory;
        this.qp = qp;
    }

    public List<String> queryUserOwnedAssets(String assetFilter) {
        this.qp.setIndexId(IndexNames.CM.toString());
        this.qp.setQueryTerm(null);
        this.qp.setFilters(Arrays.asList(SolrDocumentSecurityFilter.getAssetTypesFilter(assetFilter)));
        this.qp.setHideInternal(HideInternal.DEFAULT);
        this.qp.setMaxResults(MAX_NUMBER_OF_ASSET_REFS);
        this.qp.setReturnFields(FieldNames.ID.toString());
        SearchQueryBuilder queryBuilder = new SearchQueryBuilder(this.qp);
        QueryResult queryResult = this.solrFactory.createSolrHandler().query(IndexNames.CM.toString(), queryBuilder.build());
        return SolrDocumentSecurityFilter.extractIdsFromSearchResults(queryResult.toJSON().getArray("results"));
    }

    private static String getAssetTypesFilter(String assetFilter) {
        return assetFilter != null ? StringUtils.join((Object[])new String[]{"type|", assetFilter}) : DEFAULT_ASSET_TYPES_FILTER;
    }

    private static List<String> extractIdsFromSearchResults(JsonArray results) {
        ArrayList<String> assetIds = new ArrayList<String>();
        for (Object o : results) {
            JsonObject searchResult = (JsonObject)o;
            assetIds.add((String)searchResult.get(FieldNames.ID.toString()));
        }
        return assetIds;
    }
}

