/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.RestLogger;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.indexing.solr.SolrRequestFactory;
import com.ibm.bi.search.indexing.solr.SolrResponseProcessor;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.ConfigSetAdminResponse;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrJ {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrClient solrClient;
    private final SolrResponseProcessor responseProcessor;
    private final SolrRequestFactory requestFactory;
    private final RestLogger restLogger;

    public SolrJ(SolrClient solrClient, SolrResponseProcessor responseProcessor, SolrRequestFactory requestFactory) {
        this(solrClient, responseProcessor, requestFactory, new RestLogger(LOG));
    }

    protected SolrJ(SolrClient solrClient, SolrResponseProcessor responseProcessor, SolrRequestFactory requestFactory, RestLogger restLogger) {
        this.solrClient = solrClient;
        this.responseProcessor = responseProcessor;
        this.requestFactory = requestFactory;
        this.restLogger = restLogger;
    }

    public List<String> listCollections() {
        this.logRequest("listCollections", new Object[0]);
        try {
            List collections = CollectionAdminRequest.listCollections((SolrClient)this.solrClient);
            this.logResponse(collections);
            return collections;
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to list collections.");
        }
    }

    public NamedList<Object> createCollection(String collectionName, String config, int numShards, int numReplicas) {
        this.logRequest("createCollection(name: {}, config: {}, numShards: {}, numReplicas: {})", collectionName, config, numShards, numReplicas);
        try {
            return this.sendRequest((SolrRequest<?>)CollectionAdminRequest.createCollection((String)collectionName, (String)config, (int)numShards, (int)numReplicas));
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to create collection: " + collectionName);
        }
    }

    public NamedList<Object> deleteCollection(String collectionName) {
        this.logRequest("deleteCollection(name: {})", collectionName);
        try {
            return this.sendRequest((SolrRequest<?>)CollectionAdminRequest.deleteCollection((String)collectionName));
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to delete collection: " + collectionName);
        }
    }

    public NamedList<Object> createConfigSet(String configSetName, String baseConfigSetName) {
        this.logRequest("createConfigSet(name: {}, baseConfigSet: {})", configSetName, baseConfigSetName);
        try {
            ConfigSetAdminRequest.Create request = new ConfigSetAdminRequest.Create();
            request.setConfigSetName(configSetName);
            request.setBaseConfigSetName(baseConfigSetName);
            return this.sendRequest((SolrRequest<?>)request);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to create config set: " + configSetName);
        }
    }

    public NamedList<Object> deleteConfigSet(String configSetName) {
        this.logRequest("deleteConfigSet(name: {})", configSetName);
        try {
            return this.sendRequest((SolrRequest<?>)new ConfigSetAdminRequest.Delete().setConfigSetName(configSetName));
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to delete config set: " + configSetName);
        }
    }

    public List<String> listConfigSets() {
        this.logRequest("listConfigSets", new Object[0]);
        try {
            ConfigSetAdminRequest.List request = new ConfigSetAdminRequest.List();
            ConfigSetAdminResponse.List response = (ConfigSetAdminResponse.List)request.process(this.solrClient);
            this.logResponse((SolrResponse)response);
            return response.getConfigSets();
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to list config sets.");
        }
    }

    public JsonObject getSchemaInfo(String collectionName) {
        this.logRequest("getSchemaInfo(name: {})", collectionName);
        try {
            GenericSolrRequest request = this.requestFactory.createGetUserPropertyRequest();
            SimpleSolrResponse response = (SimpleSolrResponse)request.process(this.solrClient, collectionName);
            this.logResponse((SolrResponse)response);
            return this.responseProcessor.processMetaPropertiesResponse(response);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to get schema: " + collectionName);
        }
    }

    public NamedList<Object> createCMSchema(String collectionName, String cmInstance, String cmVersion) {
        this.logRequest("createCMSchema(name: {}, cmInstance: {}, cmVersion: {})", collectionName, cmInstance, cmVersion);
        try {
            GenericSolrRequest request = this.requestFactory.createCMSchemaInfoUserPropertyRequest(cmInstance, cmVersion);
            return this.sendRequest((SolrRequest<?>)request, collectionName);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to create CM schema: " + collectionName);
        }
    }

    public NamedList<Object> updateSchema(String collectionName, List<SchemaRequest.Update> updates) {
        this.logRequest("updateSchema(name: {}, updates: {})", collectionName, updates);
        try {
            SchemaRequest.MultiUpdate request = this.requestFactory.createMultiUpdateRequest(updates);
            return this.sendRequest((SolrRequest<?>)request, collectionName);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to update schema: " + collectionName);
        }
    }

    public List<String> listCores() {
        this.logRequest("listCores", new Object[0]);
        try {
            CoreAdminRequest request = new CoreAdminRequest();
            request.setAction(CoreAdminParams.CoreAdminAction.STATUS);
            CoreAdminResponse response = (CoreAdminResponse)request.process(this.solrClient);
            this.logResponse((SolrResponse)response);
            return this.responseProcessor.getCoreNames(response);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to list cores.");
        }
    }

    public NamedList<Object> createCore(String coreName) {
        this.logRequest("createCore(name: {})", coreName);
        try {
            CoreAdminRequest.Create request = new CoreAdminRequest.Create();
            request.setCoreName(coreName);
            request.setInstanceDir(coreName);
            return this.sendRequest((SolrRequest<?>)request);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to create core: " + coreName);
        }
    }

    public NamedList<Object> deleteCore(String coreName) {
        this.logRequest("deleteCore(name: {})", coreName);
        try {
            CoreAdminResponse response = CoreAdminRequest.unloadCore((String)coreName, (boolean)true, (boolean)true, (SolrClient)this.solrClient);
            this.logResponse((SolrResponse)response);
            return response.getResponse();
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to delete a core: " + coreName);
        }
    }

    public Date getLastModified(String coreName) {
        this.logRequest("getLastModified(name: {})", coreName);
        try {
            GenericSolrRequest request = this.requestFactory.createLastModifiedRequest(coreName);
            SimpleSolrResponse response = (SimpleSolrResponse)request.process(this.solrClient, coreName);
            this.logResponse((SolrResponse)response);
            return this.responseProcessor.processLastModifiedResponse(response, coreName);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to get last modified date: " + coreName);
        }
    }

    public String getCollectionUniqueKey(String collectionName) {
        this.logRequest("getCollectionUniqueKey(name: {})", collectionName);
        try {
            SchemaRequest.UniqueKey request = this.requestFactory.createUniqueKeyRequest();
            SchemaResponse.UniqueKeyResponse response = (SchemaResponse.UniqueKeyResponse)request.process(this.solrClient, collectionName);
            this.logResponse((SolrResponse)response);
            return this.responseProcessor.processUniqueKeyResponse(response);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to get collection unique key: " + collectionName);
        }
    }

    public JsonArray getCollectionFields(String collectionName) {
        this.logRequest("getCollectionFields(name: {})", collectionName);
        try {
            SchemaRequest.Fields request = this.requestFactory.createFieldsRequest();
            SchemaResponse.FieldsResponse response = (SchemaResponse.FieldsResponse)request.process(this.solrClient, collectionName);
            this.logResponse((SolrResponse)response);
            return this.responseProcessor.processFieldsResponse(response);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to get collection fields: " + collectionName);
        }
    }

    public JsonArray getCollectionFieldTypes(String collectionName) {
        this.logRequest("getCollectionFieldTypes(name: {})", collectionName);
        try {
            SchemaRequest.FieldTypes request = this.requestFactory.createFieldTypesRequest();
            SchemaResponse.FieldTypesResponse response = (SchemaResponse.FieldTypesResponse)request.process(this.solrClient, collectionName);
            this.logResponse((SolrResponse)response);
            return this.responseProcessor.processFieldTypesResponse(response);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to get collection field types: " + collectionName);
        }
    }

    public JsonArray getCollectionDynamicFields(String collectionName) {
        this.logRequest("getCollectionDynamicFields(name: {})", collectionName);
        try {
            SchemaRequest.DynamicFields request = this.requestFactory.createDynamicFieldsRequest();
            SchemaResponse.DynamicFieldsResponse response = (SchemaResponse.DynamicFieldsResponse)request.process(this.solrClient, collectionName);
            this.logResponse((SolrResponse)response);
            return this.responseProcessor.processDynamicFieldsResponse(response);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to get collection dynamic fields: " + collectionName);
        }
    }

    public JsonArray getCollectionCopyFields(String collectionName) {
        this.logRequest("getCollectionCopyFields(name: {})", collectionName);
        try {
            SchemaRequest.CopyFields request = this.requestFactory.createCopyFieldsRequest();
            SchemaResponse.CopyFieldsResponse response = (SchemaResponse.CopyFieldsResponse)request.process(this.solrClient, collectionName);
            this.logResponse((SolrResponse)response);
            return this.responseProcessor.processCopyFieldsResponse(response);
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to get collection copy fields: " + collectionName);
        }
    }

    public QueryResponse query(String collectionName, SolrQuery query) {
        this.logRequest("query(name: {}, query: {})", collectionName, query);
        try {
            QueryResponse response = this.solrClient.query(collectionName, (SolrParams)query);
            this.logResponse((SolrResponse)response);
            return response;
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to query collection: " + collectionName);
        }
    }

    public UpdateResponse commit(String collectionName, boolean waitFlush, boolean waitSearcher, boolean softCommit) {
        this.logRequest("commit(name: {}, query: {}, waitFlush: {},  waitSearcher: {},  softCommit: {})", collectionName, waitFlush, waitSearcher, softCommit);
        try {
            UpdateResponse response = this.solrClient.commit(collectionName, waitFlush, waitSearcher, softCommit);
            this.logResponse((SolrResponse)response);
            return response;
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to commit: " + collectionName);
        }
    }

    public UpdateResponse add(String collectionName, SolrInputDocument solrDocument) {
        this.logRequest("add(name: {}, solrDocument: {})", collectionName, solrDocument);
        try {
            UpdateResponse response = this.solrClient.add(collectionName, solrDocument);
            this.logResponse((SolrResponse)response);
            return response;
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to add document: " + solrDocument);
        }
    }

    public UpdateResponse deleteById(String collectionName, String documentId) {
        this.logRequest("deleteById(name: {}, documentId: {})", collectionName, documentId);
        try {
            UpdateResponse response = this.solrClient.deleteById(collectionName, documentId);
            this.logResponse((SolrResponse)response);
            return response;
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to delete document by id: " + documentId);
        }
    }

    public UpdateResponse deleteByQuery(String collectionName, String query) {
        this.logRequest("deleteByQuery(name: {}, query: {})", collectionName, query);
        try {
            UpdateResponse response = this.solrClient.deleteByQuery(collectionName, query);
            this.logResponse((SolrResponse)response);
            return response;
        }
        catch (Exception e) {
            throw this.createSearchException(e, "Failed to delete by query: " + query);
        }
    }

    private NamedList<Object> sendRequest(SolrRequest<?> request) throws SolrServerException, IOException {
        return this.sendRequest(request, null);
    }

    private NamedList<Object> sendRequest(SolrRequest<?> request, String collectionName) throws SolrServerException, IOException {
        SolrResponse response = request.process(this.solrClient, collectionName);
        this.logResponse(response);
        return response.getResponse();
    }

    private void logResponse(SolrResponse response) {
        this.restLogger.logSolrResponse(response);
    }

    private void logResponse(List<String> response) {
        this.restLogger.logSolrResponse(response);
    }

    private void logRequest(String msg, Object ... args) {
        this.restLogger.logSolrRequest(msg, args);
    }

    private SearchException createSearchException(Exception e, String msg) {
        this.restLogger.logSolrException(e, msg);
        return SearchException.wrap(e, msg, new Object[0]);
    }
}

