/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrProperties
extends LinkedHashMap<String, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 1L;
    private static final List<String> PROPERTIES_REQUIRING_SPECIAL_HANDLING = new ArrayList<String>(Arrays.asList("analyzer", "indexAnalyzer", "queryAnalyzer", "filters", "charFilters", "tokenizer"));

    public void addMandatoryProperty(String name, JsonObject field) {
        Object value = field.get(name);
        if (value == null) {
            SolrProperties.throwSearchException(name);
        }
        this.put(name, value);
    }

    private static void throwSearchException(String name) {
        LOG.debug("The property '{}' is required in the schema.", (Object)name);
        throw new SearchException(SearchMessageKeys.FIELD_NULL, name);
    }

    public void addOptionalProperty(String name, JsonObject field) {
        Object value = field.get(name);
        if (value != null) {
            this.put(name, value);
        }
    }

    public void addOptionalFields(String name, JsonArray fields) {
        if (fields != null) {
            this.put(name, fields);
        }
    }

    public void addAllProperties(JsonObject object) {
        for (String key : object.keySet()) {
            if (PROPERTIES_REQUIRING_SPECIAL_HANDLING.contains(key)) continue;
            this.addMandatoryProperty(key, object);
        }
    }
}

