/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.indexing.solr.SolrDocumentSecurityFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;

public class SolrQueryFactory {
    private static final String ALL_DOCUMENTS = "*";
    private static final Integer DEFAULT_ROWS = 100;
    private static final Integer NOT_PROCESSED_DEFAULT_ROWS = 10;
    private static final String ASSET_TYPES = "assetTypes";
    private static final String DEFAULT_QUERY_FIELD = FieldNames.ID.toString();
    private static final String OR = " OR ";
    private SolrDocumentSecurityFilter securityFilter;

    public SolrQueryFactory() {
        this(new SolrDocumentSecurityFilter());
    }

    protected SolrQueryFactory(SolrDocumentSecurityFilter filter) {
        this.securityFilter = filter;
    }

    public SolrQuery createSolrQuery(SolrQueryParameters qp) {
        SolrQuery solrQuery = new SolrQuery();
        SolrQueryFactory.setParams(solrQuery, qp);
        SolrQueryFactory.setDefaultQueryFields(solrQuery);
        return solrQuery;
    }

    public SolrQuery createSolrSecureQuery(SolrQueryParameters qp) {
        List<String> currentFilters = SolrQueryFactory.getCurrentFilterList(qp);
        String securedByFQ = this.createSecuredByFQ((String)qp.get(ASSET_TYPES));
        if (StringUtils.isNotEmpty((String)securedByFQ)) {
            currentFilters.add(securedByFQ);
        }
        qp.put("fq", currentFilters);
        return this.createSolrQuery(qp);
    }

    private String createSecuredByFQ(String assetFilter) {
        List<String> allowedAssetRefs = this.securityFilter.queryUserOwnedAssets(assetFilter);
        if (CollectionUtils.isNotEmpty(allowedAssetRefs)) {
            return String.format("{!securedBy assetRefs=%s}", String.join((CharSequence)",", allowedAssetRefs));
        }
        return null;
    }

    private static List<String> getCurrentFilterList(SolrQueryParameters qp) {
        if (SolrQueryFactory.queryParamsContainsFQList(qp)) {
            return (List)qp.get("fq");
        }
        if (SolrQueryFactory.queryParamsContainsSingleFQ(qp)) {
            ArrayList<String> filters = new ArrayList<String>();
            filters.add((String)qp.get("fq"));
            return filters;
        }
        return new ArrayList<String>();
    }

    private static boolean queryParamsContainsFQList(SolrQueryParameters qp) {
        return qp.containsKey("fq") && qp.get("fq") instanceof List;
    }

    private static boolean queryParamsContainsSingleFQ(SolrQueryParameters qp) {
        return qp.containsKey("fq") && qp.get("fq") instanceof String;
    }

    private static void setParams(SolrQuery solrQuery, SolrQueryParameters qp) {
        for (Map.Entry parameter : qp.entrySet()) {
            SolrQueryFactory.setParam(solrQuery, (String)parameter.getKey(), parameter.getValue());
        }
    }

    private static void setParam(SolrQuery solrQuery, String name, Object value) {
        if (value instanceof Boolean) {
            solrQuery.setParam(name, ((Boolean)value).booleanValue());
        } else if (value instanceof List) {
            solrQuery.setParam(name, SolrQueryFactory.toList(value));
        } else {
            solrQuery.setParam(name, new String[]{value.toString()});
        }
    }

    private static String[] toList(Object value) {
        return ((List)value).toArray(new String[0]);
    }

    private static void setDefaultQueryFields(SolrQuery solrQuery) {
        if (solrQuery.getFields() == null) {
            solrQuery.setFields(new String[]{"* score"});
        }
    }

    public String createDeleteByQuery(JsonArray deleteIds) {
        return SolrQueryFactory.createQueryValueFromIds(DEFAULT_QUERY_FIELD, deleteIds);
    }

    public String createDeleteByQuery(String field, JsonArray deleteIds) {
        return SolrQueryFactory.createQueryValueFromIds(field, deleteIds);
    }

    public String createDeleteByQuery(String field, List<String> deleteIds) {
        return SolrQueryFactory.createQueryValueFromIds(field, deleteIds);
    }

    public SolrQueryParameters createQueryByIds(List<String> ids) {
        return this.createQueryByField(ids, DEFAULT_QUERY_FIELD);
    }

    public SolrQueryParameters createQueryByField(List<String> values, String fieldName) {
        SolrQueryParameters qp = new SolrQueryParameters(new Object[0]);
        qp.put("q", ALL_DOCUMENTS);
        qp.put("defType", "edismax");
        qp.put("fq", SolrQueryFactory.createQueryValueFromIds(fieldName, values));
        qp.put("rows", values.size() + DEFAULT_ROWS);
        return qp;
    }

    private static String createQueryValueFromIds(String field, List<?> ids) {
        ArrayList<String> filters = new ArrayList<String>();
        for (Object o : ids) {
            String id = o.toString();
            if (!StringUtils.isNotEmpty((String)id)) continue;
            filters.add(String.format("%s:%s", field, id));
        }
        return String.join((CharSequence)OR, filters);
    }

    public SolrQueryParameters createQueryForNotProcessedContent() {
        SolrQueryParameters qp = new SolrQueryParameters(new Object[0]);
        qp.put("q", ALL_DOCUMENTS);
        qp.put("defType", "edismax");
        qp.put("fq", "content:_NOT_PROCESSED_");
        qp.put("rows", NOT_PROCESSED_DEFAULT_ROWS);
        return qp;
    }
}

