/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.SearchService;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.SchemaProperties;
import com.ibm.bi.search.indexing.solr.SolrProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.schema.AnalyzerDefinition;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SolrRequestFactory {
    private static final String ADMIN_ENDPOINT = "/admin/cores";
    private static final String CONFIG_ENDPOINT = "/config";
    private static final String OVERLAY_ENDPOINT = "/config/overlay";
    private static final String USER_PROPERTY_BODY_TEMPLATE = "{\"set-user-property\": {\"%s\": \"%s\", \"%s\": \"%s\", \"%s\": \"%s\"}}";

    public SchemaRequest.AddField createAddFieldRequest(JsonObject field) {
        SolrProperties fieldProperties = new SolrProperties();
        fieldProperties.addMandatoryProperty(FieldNames.NAME.toString(), field);
        fieldProperties.addMandatoryProperty(FieldNames.TYPE.toString(), field);
        fieldProperties.addOptionalProperty(SchemaProperties.INDEXED.toString(), field);
        fieldProperties.addOptionalProperty(SchemaProperties.STORED.toString(), field);
        fieldProperties.addOptionalProperty(SchemaProperties.REQUIRED.toString(), field);
        fieldProperties.addOptionalProperty(SchemaProperties.MULTI_VALUED.toString(), field);
        return new SchemaRequest.AddField((Map)fieldProperties);
    }

    public SchemaRequest.ReplaceField createReplaceFieldRequest(JsonObject field) {
        SolrProperties fieldProperties = new SolrProperties();
        fieldProperties.addMandatoryProperty(FieldNames.NAME.toString(), field);
        fieldProperties.addMandatoryProperty(FieldNames.TYPE.toString(), field);
        fieldProperties.addOptionalProperty(SchemaProperties.INDEXED.toString(), field);
        fieldProperties.addOptionalProperty(SchemaProperties.STORED.toString(), field);
        fieldProperties.addOptionalProperty(SchemaProperties.REQUIRED.toString(), field);
        fieldProperties.addOptionalProperty(SchemaProperties.MULTI_VALUED.toString(), field);
        return new SchemaRequest.ReplaceField((Map)fieldProperties);
    }

    public SchemaRequest.AddDynamicField createAddDynamicFieldRequest(JsonObject dynamicField) {
        SolrProperties dynamicFieldProps = new SolrProperties();
        dynamicFieldProps.addAllProperties(dynamicField);
        return new SchemaRequest.AddDynamicField((Map)dynamicFieldProps);
    }

    public SchemaRequest.ReplaceDynamicField createReplaceDynamicFieldRequest(JsonObject dynamicField) {
        SolrProperties dynamicFieldProps = new SolrProperties();
        dynamicFieldProps.addAllProperties(dynamicField);
        return new SchemaRequest.ReplaceDynamicField((Map)dynamicFieldProps);
    }

    public SchemaRequest.AddCopyField createAddCopyFieldRequest(JsonObject copyField) {
        return new SchemaRequest.AddCopyField(copyField.getString(SchemaProperties.SOURCE.toString()), new ArrayList<String>(Arrays.asList(copyField.getString(SchemaProperties.DEST.toString()))));
    }

    public SchemaRequest.AddFieldType createAddFieldTypeRequest(JsonObject fieldType) {
        FieldTypeDefinition definition = SolrRequestFactory.buildFieldTypeDefinition(fieldType);
        return new SchemaRequest.AddFieldType(definition);
    }

    public SchemaRequest.ReplaceFieldType createReplaceFieldTypeRequest(JsonObject fieldType) {
        FieldTypeDefinition definition = SolrRequestFactory.buildFieldTypeDefinition(fieldType);
        return new SchemaRequest.ReplaceFieldType(definition);
    }

    public SchemaRequest.MultiUpdate createMultiUpdateRequest(List<SchemaRequest.Update> updates) {
        return new SchemaRequest.MultiUpdate(updates);
    }

    private static FieldTypeDefinition buildFieldTypeDefinition(JsonObject fieldType) {
        FieldTypeDefinition fieldTypeDef = new FieldTypeDefinition();
        if (fieldType.containsKey((Object)SchemaProperties.ANALYZER.toString())) {
            fieldTypeDef.setAnalyzer(SolrRequestFactory.buildAnalyzerDefinition(fieldType.getObject(SchemaProperties.ANALYZER.toString())));
        }
        if (fieldType.containsKey((Object)SchemaProperties.INDEX_ANALYZER.toString())) {
            fieldTypeDef.setIndexAnalyzer(SolrRequestFactory.buildAnalyzerDefinition(fieldType.getObject(SchemaProperties.INDEX_ANALYZER.toString())));
        }
        if (fieldType.containsKey((Object)SchemaProperties.QUERY_ANALYZER.toString())) {
            fieldTypeDef.setQueryAnalyzer(SolrRequestFactory.buildAnalyzerDefinition(fieldType.getObject(SchemaProperties.QUERY_ANALYZER.toString())));
        }
        fieldTypeDef.setAttributes((Map)SolrRequestFactory.addAllTopLevelProperties(fieldType));
        return fieldTypeDef;
    }

    private static AnalyzerDefinition buildAnalyzerDefinition(JsonObject analyzer) {
        AnalyzerDefinition analyzerDefinition = new AnalyzerDefinition();
        if (analyzer.containsKey((Object)SchemaProperties.TOKENIZER.toString())) {
            analyzerDefinition.setTokenizer((Map)SolrRequestFactory.buildTokenizer(analyzer.getObject(SchemaProperties.TOKENIZER.toString())));
        }
        if (analyzer.containsKey((Object)SchemaProperties.FILTERS.toString())) {
            analyzerDefinition.setFilters(SolrRequestFactory.buildFilters(analyzer.getArray(SchemaProperties.FILTERS.toString())));
        }
        if (analyzer.containsKey((Object)SchemaProperties.CHAR_FILTERS.toString())) {
            analyzerDefinition.setCharFilters(SolrRequestFactory.buildFilters(analyzer.getArray(SchemaProperties.CHAR_FILTERS.toString())));
        }
        return analyzerDefinition;
    }

    private static SolrProperties buildTokenizer(JsonObject tokenizer) {
        return SolrRequestFactory.addAllTopLevelProperties(tokenizer);
    }

    private static List<Map<String, Object>> buildFilters(JsonArray filters) {
        ArrayList<Map<String, Object>> builtFilters = new ArrayList<Map<String, Object>>();
        for (Object filter : filters) {
            builtFilters.add(SolrRequestFactory.addAllTopLevelProperties((JsonObject)filter));
        }
        return builtFilters;
    }

    private static SolrProperties addAllTopLevelProperties(JsonObject object) {
        SolrProperties properties = new SolrProperties();
        properties.addAllProperties(object);
        return properties;
    }

    public GenericSolrRequest createLastModifiedRequest(String collectionId) {
        HashMap<String, String> lastModifiedParams = new HashMap<String, String>();
        lastModifiedParams.put("action", "STATUS");
        lastModifiedParams.put("core", collectionId);
        return new GenericSolrRequest(SolrRequest.METHOD.GET, ADMIN_ENDPOINT, (SolrParams)new MapSolrParams(lastModifiedParams));
    }

    public GenericSolrRequest createCMSchemaInfoUserPropertyRequest(String cmInstance, String cmVersion) {
        GenericSolrRequest cmSchemaInfoReq = new GenericSolrRequest(SolrRequest.METHOD.POST, CONFIG_ENDPOINT, (SolrParams)new ModifiableSolrParams());
        SolrRequestFactory.setUserPropertyReqBody(cmSchemaInfoReq, SolrRequestFactory.generateCmSchemaReqBody(cmInstance, cmVersion));
        return cmSchemaInfoReq;
    }

    private static String generateCmSchemaReqBody(String cmInstance, String cmVersion) {
        return String.format(USER_PROPERTY_BODY_TEMPLATE, SchemaProperties.INSTANCE.toString(), cmInstance, SchemaProperties.VERSION.toString(), cmVersion, SchemaProperties.SEARCH_VERSION.toString(), SearchService.getVersion());
    }

    private static void setUserPropertyReqBody(GenericSolrRequest userPropertyReq, String body) {
        RequestWriter.StringPayloadContentWriter writer = new RequestWriter.StringPayloadContentWriter(body, "application/json");
        userPropertyReq.setContentWriter((RequestWriter.ContentWriter)writer);
    }

    public GenericSolrRequest createGetUserPropertyRequest() {
        return new GenericSolrRequest(SolrRequest.METHOD.GET, OVERLAY_ENDPOINT, (SolrParams)new ModifiableSolrParams());
    }

    public SchemaRequest.UniqueKey createUniqueKeyRequest() {
        return new SchemaRequest.UniqueKey();
    }

    public SchemaRequest.Fields createFieldsRequest() {
        return new SchemaRequest.Fields();
    }

    public SchemaRequest.FieldTypes createFieldTypesRequest() {
        return new SchemaRequest.FieldTypes();
    }

    public SchemaRequest.DynamicFields createDynamicFieldsRequest() {
        return new SchemaRequest.DynamicFields();
    }

    public SchemaRequest.CopyFields createCopyFieldsRequest() {
        return new SchemaRequest.CopyFields();
    }
}

