/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.constants.SchemaProperties;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.request.schema.AnalyzerDefinition;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.client.solrj.response.schema.FieldTypeRepresentation;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrResponseProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Logger logger;

    public SolrResponseProcessor() {
        this(LOG);
    }

    protected SolrResponseProcessor(Logger logger) {
        this.logger = logger;
    }

    public String processUniqueKeyResponse(SchemaResponse.UniqueKeyResponse response) {
        return response.getUniqueKey();
    }

    public JsonArray processFieldsResponse(SchemaResponse.FieldsResponse response) {
        JsonArray fieldsArray = new JsonArray();
        Iterator fieldsItr = response.getFields().iterator();
        while (fieldsItr.hasNext()) {
            fieldsArray.add((Object)new JsonObject((Map)fieldsItr.next()));
        }
        return fieldsArray;
    }

    public JsonArray processFieldTypesResponse(SchemaResponse.FieldTypesResponse response) {
        JsonArray fieldTypesArray = new JsonArray();
        for (FieldTypeRepresentation fieldType : response.getFieldTypes()) {
            fieldTypesArray.add((Object)SolrResponseProcessor.unbuildFieldTypeRepresentation(fieldType));
        }
        return fieldTypesArray;
    }

    private static JsonObject unbuildFieldTypeRepresentation(FieldTypeRepresentation fieldType) {
        JsonObject fieldTypeObj = new JsonObject(fieldType.getAttributes());
        if (fieldType.getAnalyzer() != null) {
            fieldTypeObj.put(SchemaProperties.ANALYZER.toString(), (Object)SolrResponseProcessor.unbuildAnalyzerDefinition(fieldType.getAnalyzer()));
        }
        if (fieldType.getIndexAnalyzer() != null) {
            fieldTypeObj.put(SchemaProperties.INDEX_ANALYZER.toString(), (Object)SolrResponseProcessor.unbuildAnalyzerDefinition(fieldType.getIndexAnalyzer()));
        }
        if (fieldType.getQueryAnalyzer() != null) {
            fieldTypeObj.put(SchemaProperties.QUERY_ANALYZER.toString(), (Object)SolrResponseProcessor.unbuildAnalyzerDefinition(fieldType.getQueryAnalyzer()));
        }
        return fieldTypeObj;
    }

    private static JsonObject unbuildAnalyzerDefinition(AnalyzerDefinition analyzer) {
        JsonObject analyzerDefinition = new JsonObject(analyzer.getAttributes());
        if (analyzer.getTokenizer() != null) {
            analyzerDefinition.put(SchemaProperties.TOKENIZER.toString(), (Object)SolrResponseProcessor.unbuildTokenizer(analyzer.getTokenizer()));
        }
        if (analyzer.getFilters() != null) {
            analyzerDefinition.put(SchemaProperties.FILTERS.toString(), (Object)SolrResponseProcessor.unbuildFilters(analyzer.getFilters()));
        }
        if (analyzer.getCharFilters() != null) {
            analyzerDefinition.put(SchemaProperties.CHAR_FILTERS.toString(), (Object)SolrResponseProcessor.unbuildFilters(analyzer.getCharFilters()));
        }
        return analyzerDefinition;
    }

    private static JsonObject unbuildTokenizer(Map<String, Object> tokenizer) {
        return new JsonObject(tokenizer);
    }

    private static JsonArray unbuildFilters(List<Map<String, Object>> filters) {
        JsonArray unbuiltFilters = new JsonArray();
        for (Map<String, Object> filter : filters) {
            unbuiltFilters.add((Object)new JsonObject(filter));
        }
        return unbuiltFilters;
    }

    public JsonArray processDynamicFieldsResponse(SchemaResponse.DynamicFieldsResponse response) {
        JsonArray dynamicFields = new JsonArray();
        for (Map dynamicField : response.getDynamicFields()) {
            dynamicFields.add((Object)SolrResponseProcessor.unbuildCopyOrDynamicField(dynamicField));
        }
        return dynamicFields;
    }

    public JsonArray processCopyFieldsResponse(SchemaResponse.CopyFieldsResponse response) {
        JsonArray copyFields = new JsonArray();
        for (Map copyField : response.getCopyFields()) {
            copyFields.add((Object)SolrResponseProcessor.unbuildCopyOrDynamicField(copyField));
        }
        return copyFields;
    }

    private static JsonObject unbuildCopyOrDynamicField(Map<String, Object> copyField) {
        return new JsonObject(copyField);
    }

    public Date processLastModifiedResponse(SimpleSolrResponse lastModifiedResponse, String collectionName) {
        SimpleOrderedMap collectionData = (SimpleOrderedMap)((SimpleOrderedMap)lastModifiedResponse.nl.get(SchemaProperties.STATUS.toString())).get(collectionName);
        if (SolrResponseProcessor.propertyExistsInMap((SimpleOrderedMap)collectionData.get(SchemaProperties.INDEX.toString()), SchemaProperties.LAST_MODIFIED.toString())) {
            return (Date)((SimpleOrderedMap)collectionData.get(SchemaProperties.INDEX.toString())).get(SchemaProperties.LAST_MODIFIED.toString());
        }
        if (SolrResponseProcessor.propertyExistsInMap(collectionData, SchemaProperties.START_TIME.toString())) {
            return (Date)collectionData.get(SchemaProperties.START_TIME.toString());
        }
        return null;
    }

    private static boolean propertyExistsInMap(SimpleOrderedMap map, String property) {
        return map != null && map.get(property) != null;
    }

    public JsonObject processMetaPropertiesResponse(SimpleSolrResponse response) {
        LinkedHashMap overlay = (LinkedHashMap)response.nl.get(SchemaProperties.OVERLAY.toString());
        if (overlay != null && overlay.get(SchemaProperties.USER_PROPS.toString()) != null) {
            return new JsonObject((Map)((LinkedHashMap)overlay.get(SchemaProperties.USER_PROPS.toString())));
        }
        return new JsonObject();
    }

    public List<String> getCoreNames(CoreAdminResponse response) {
        this.checkForInitFailures(response);
        return SolrResponseProcessor.extractCoreNames(response);
    }

    private void checkForInitFailures(CoreAdminResponse response) {
        Map<String, Object> initFailures = SolrResponseProcessor.getInitFailures(response);
        if (initFailures != null && initFailures.size() > 0) {
            this.logger.error("Failed to initialize one or more indices: {}", initFailures);
            throw new SearchException(SearchMessageKeys.ERROR_CREATING_INDEX, initFailures.toString());
        }
    }

    private static Map<String, Object> getInitFailures(CoreAdminResponse response) {
        return (Map)response.getResponse().get("initFailures");
    }

    private static List<String> extractCoreNames(CoreAdminResponse response) {
        ArrayList<String> coreNames = new ArrayList<String>();
        NamedList coreStatus = response.getCoreStatus();
        if (coreStatus != null) {
            for (int i = 0; i < coreStatus.size(); ++i) {
                coreNames.add(coreStatus.getName(i));
            }
        }
        return coreNames;
    }
}

