/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionChecker {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String UTF_8 = StandardCharsets.UTF_8.toString();
    private static final String VERSION_START = "<luceneMatchVersion>";
    private static final String VERSION_END = "</luceneMatchVersion>";
    private static final String NO_VERSION = "";
    private static final String SOLRCONFIG_XML = "solrconfig.xml";
    private static final String SOLRCONFIG_PATH = "/config/configsets/basic_configs/conf/solrconfig.xml";
    private File collectionsDir;
    private File productSolrConfigXml;

    public VersionChecker(String collectionsDir, String configurationSearchDir) {
        this.collectionsDir = new File(collectionsDir);
        this.productSolrConfigXml = new File(configurationSearchDir + SOLRCONFIG_PATH);
    }

    public void enforceSolrVersion() {
        String productSolrVersion = this.getSolrVersion(this.productSolrConfigXml);
        this.deleteCollectionsWithDifferentSolrVersions(productSolrVersion);
    }

    private void deleteCollectionsWithDifferentSolrVersions(String expectedVersion) {
        for (File solrConfig : this.getAllSolrConfigs()) {
            String version = this.getSolrVersion(solrConfig);
            if (version.equals(expectedVersion)) continue;
            LOG.warn("Deleting index [{}] with a different Solr version [{}] than the one in the product [{}].", new Object[]{this.getCollectionName(solrConfig), version, expectedVersion});
            this.deleteCollection(solrConfig);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSolrVersion(File solrConfig) {
        try (Scanner s = new Scanner(solrConfig, UTF_8);){
            String versionElement = s.findWithinHorizon("<luceneMatchVersion>(.*?)</luceneMatchVersion>", 0);
            String string = this.extractVersionNumber(versionElement);
            return string;
        }
        catch (Exception e) {
            LOG.error("Failed to scan Solr Config: " + solrConfig.getPath(), (Throwable)e);
            return NO_VERSION;
        }
    }

    private String extractVersionNumber(String versionElement) {
        return versionElement.substring(VERSION_START.length(), versionElement.indexOf(VERSION_END));
    }

    private Collection<File> getAllSolrConfigs() {
        if (this.collectionsDir.exists()) {
            return this.findSolrConfigFiles();
        }
        return Collections.emptyList();
    }

    private Collection<File> findSolrConfigFiles() {
        String[] dirs = this.collectionsDir.list((FilenameFilter)DirectoryFileFilter.INSTANCE);
        if (dirs != null) {
            return this.findSolrConfigFiles(dirs);
        }
        return Collections.emptyList();
    }

    private Collection<File> findSolrConfigFiles(String[] dirs) {
        ArrayList<File> solrConfigFiles = new ArrayList<File>();
        for (String d : dirs) {
            File f = this.getSolrConfigFile(d);
            if (!f.exists()) continue;
            solrConfigFiles.add(f);
        }
        return solrConfigFiles;
    }

    private File getSolrConfigFile(String dir) {
        return Paths.get(this.collectionsDir.getAbsolutePath(), dir, "conf", SOLRCONFIG_XML).toFile();
    }

    private String getCollectionName(File solrConfig) {
        return this.getCollectionDir(solrConfig).getName();
    }

    private File getCollectionDir(File solrConfig) {
        return solrConfig.getParentFile().getParentFile();
    }

    private void deleteCollection(File solrConfig) {
        File collectionDir = this.getCollectionDir(solrConfig);
        try {
            FileUtils.deleteDirectory((File)collectionDir);
        }
        catch (IOException e) {
            LOG.error("Failed to delete collections folder: " + collectionDir, (Throwable)e);
        }
    }
}

