/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.cm;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.ObjectTypes;
import com.ibm.bi.search.util.Ancestors;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMAncestorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Set<String> UI_HIDING_PARENTS = CMAncestorHelper.createUiHidingParents();

    private CMAncestorHelper() {
    }

    private static HashSet<String> createUiHidingParents() {
        return new HashSet<String>(Arrays.asList(ObjectTypes.EXPLORATION.toString(), ObjectTypes.AGENT_DEFINITION.toString(), ObjectTypes.REPORT.toString(), ObjectTypes.DASHBOARD.toString()));
    }

    public static String computeIsInternal(JsonObject document, JsonArray ancestors) {
        Map<String, JsonObject> sortedAncestors = CMAncestorHelper.sortAncestorsByPath(document, ancestors);
        if (CMAncestorHelper.ancestorIsMissingFromAncestorsSet(document, sortedAncestors)) {
            LOG.debug("The ancestor set provided to compute is_internal is missing an ancestor in the path.");
            return "unknown";
        }
        if (CMAncestorHelper.hasUnknownAncestor(sortedAncestors, FieldNames.IS_INTERNAL)) {
            LOG.debug("The ancestor set provided to compute is_internal has one unknown ancestor: {}", sortedAncestors);
            return "unknown";
        }
        if (CMAncestorHelper.isHiddenBasedOnParentType(sortedAncestors)) {
            return Boolean.TRUE.toString();
        }
        if (CMAncestorHelper.isPublicFoldersOnTop(sortedAncestors) || CMAncestorHelper.isFolderUnderAccount(sortedAncestors)) {
            return Boolean.FALSE.toString();
        }
        return Boolean.TRUE.toString();
    }

    private static boolean ancestorIsMissingFromAncestorsSet(JsonObject document, Map<String, JsonObject> ancestorDocuments) {
        List<String> ancestorIds = Ancestors.getAncestorIds(document);
        return ancestorIds.size() != ancestorDocuments.size();
    }

    private static boolean hasUnknownAncestor(Map<String, JsonObject> ancestors, FieldNames fieldName) {
        for (JsonObject ancestor : ancestors.values()) {
            if (!CMAncestorHelper.isUnknown(ancestor, fieldName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnknown(JsonObject ancestor, FieldNames fieldName) {
        return ancestor != null && "unknown".equals(ancestor.getString(fieldName.toString()));
    }

    private static boolean isHiddenBasedOnParentType(Map<String, JsonObject> ancestors) {
        for (JsonObject ancestor : ancestors.values()) {
            if (ancestor == null || !ancestor.containsKey((Object)FieldNames.TYPE.toString()) || !CMAncestorHelper.isAHidingParent(ancestor.getString(FieldNames.TYPE.toString()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isAHidingParent(String parentType) {
        return UI_HIDING_PARENTS.contains(parentType);
    }

    private static boolean isPublicFoldersOnTop(Map<String, JsonObject> ancestors) {
        for (JsonObject ancestor : ancestors.values()) {
            if (!ObjectTypes.PUBLIC_FOLDERS.toString().equals(ancestor.get(FieldNames.TYPE.toString()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isFolderUnderAccount(Map<String, JsonObject> ancestors) {
        String previousType = "";
        for (JsonObject ancestor : ancestors.values()) {
            String currentType = ancestor.getString(FieldNames.TYPE.toString());
            if (ObjectTypes.ACCOUNT.toString().equals(previousType) && ObjectTypes.FOLDER.toString().equals(currentType)) {
                return true;
            }
            previousType = currentType;
        }
        return false;
    }

    public static String computeUserVisibility(JsonObject document, JsonArray ancestors) {
        Map<String, JsonObject> sortedAncestors = CMAncestorHelper.sortAncestorsByPath(document, ancestors);
        if (CMAncestorHelper.ancestorIsMissingFromAncestorsSet(document, sortedAncestors)) {
            LOG.debug("The ancestor set provided to compute the user visibility is missing an ancestor");
            return "unknown";
        }
        if (CMAncestorHelper.hasUnknownAncestor(sortedAncestors, FieldNames.USER_VISIBILITY)) {
            LOG.debug("The ancestor set provided to compute the user visibility has an unknown ancestor: {}", sortedAncestors);
            return "unknown";
        }
        if (CMAncestorHelper.isAccount(document)) {
            return document.getString(FieldNames.ID.toString()).toLowerCase();
        }
        for (JsonObject ancestor : sortedAncestors.values()) {
            if (!CMAncestorHelper.isAccount(ancestor)) continue;
            return ancestor.getString(FieldNames.ID.toString()).toLowerCase();
        }
        return "all";
    }

    private static boolean isAccount(JsonObject document) {
        return ObjectTypes.ACCOUNT.toString().equals(document.getString(FieldNames.TYPE.toString()));
    }

    private static Map<String, JsonObject> sortAncestorsByPath(JsonObject document, JsonArray originalAncestors) {
        String ancestorPath = Ancestors.getAncestorPath(document);
        return Ancestors.sortByPath(ancestorPath, originalAncestors);
    }
}

