/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.cm;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.indexing.solr.cm.CMAncestorHelper;
import com.ibm.bi.search.indexing.solr.cm.CMFieldBuilder;

public class CMDocumentAdapter {
    private JsonObject document;
    private JsonArray ancestors;

    public CMDocumentAdapter(JsonObject document, JsonArray ancestors) {
        this.document = document;
        this.ancestors = ancestors;
    }

    public JsonObject adapt() {
        try {
            this.buildVisibilityFields();
            return this.buildIndexFields();
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "A parsing exception occurred while transforming CM document: " + this.document, new Object[0]);
        }
    }

    private void buildVisibilityFields() {
        this.document.put(FieldNames.IS_INTERNAL.toString(), (Object)CMAncestorHelper.computeIsInternal(this.document, this.ancestors));
        this.document.put(FieldNames.USER_VISIBILITY.toString(), (Object)CMAncestorHelper.computeUserVisibility(this.document, this.ancestors));
    }

    private JsonObject buildIndexFields() {
        CMFieldBuilder fieldBuilder = new CMFieldBuilder(this.document);
        return fieldBuilder.build();
    }
}

