/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.cm;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.constants.ObjectTypes;
import com.ibm.bi.search.language.SolrLanguageHandler;
import com.ibm.bi.search.util.SearchFieldUtils;
import com.ibm.bi.search.util.SearchUtils;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMFieldBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String MULTILINGUAL_FIELD_TEMPLATE = "%s_%s";
    private static final String NAME = FieldNames.NAME.toString();
    private static final String NAME_EXACT = FieldNames.NAME_EXACT.toString();
    private final SolrLanguageHandler languageHandler = new SolrLanguageHandler();
    private final JsonObject document;
    private final JsonObject builtDocument = new JsonObject();
    private final Set<String> nameExact = new LinkedHashSet<String>();

    public CMFieldBuilder(JsonObject document) {
        this.document = document;
    }

    public JsonObject build() {
        for (String field : this.document.keySet()) {
            this.buildField(field);
        }
        this.finishBuildingIndexFields();
        return this.builtDocument;
    }

    private void buildField(String field) {
        String fieldType = SearchFieldUtils.getSearchFieldType(IndexNames.CM.toString(), field);
        if (StringUtils.isEmpty((String)fieldType)) {
            LOG.debug("Attempted to build index field:{}, but it was not recognized. This field will be ignored.", (Object)field);
            return;
        }
        switch (fieldType) {
            case "content": {
                this.buildContentField(field);
                break;
            }
            case "multilingual": {
                this.buildMultilingualField(field);
                break;
            }
            case "tenant": {
                this.buildTenantField(field);
                break;
            }
            case "policy": {
                break;
            }
            default: {
                this.builtDocument.put(field, this.document.get(field));
            }
        }
    }

    private void buildContentField(String field) {
        this.builtDocument.put(FieldNames.CONTENT.toString(), this.document.get(field));
        String documentType = (String)this.document.get(FieldNames.TYPE.toString());
        if (SearchUtils.isParentTypeOfOutput(documentType)) {
            this.builtDocument.put(FieldNames.COMBINED_CONTENT.toString(), (Object)"_NOT_PROCESSED_");
        }
    }

    private static boolean isOutputType(String type) {
        return ObjectTypes.OUTPUT.toString().equals(type);
    }

    private void buildMultilingualField(String field) {
        JsonObject value = this.document.getObject(field);
        for (String locale : value.keySet()) {
            if (this.isDefaultLocale(locale)) {
                String trimmedValue = this.languageHandler.getLanguageCode(value.getString(locale));
                this.builtDocument.put(String.format(MULTILINGUAL_FIELD_TEMPLATE, locale, field), (Object)trimmedValue);
                continue;
            }
            String mappedLocale = this.languageHandler.getLanguageCode(locale);
            if (this.languageHandler.isSupported(mappedLocale)) {
                String localizedValue = value.getString(locale);
                this.builtDocument.put(String.format(MULTILINGUAL_FIELD_TEMPLATE, field, mappedLocale), (Object)localizedValue);
                this.addNameExact(field, localizedValue);
                continue;
            }
            LOG.debug("Removing field [{}] with unsupported locale [{}] from document: {}", new Object[]{field, mappedLocale, this.builtDocument});
        }
    }

    private boolean isDefaultLocale(String locale) {
        return FieldNames.DEFAULT_LOCALE.toString().equals(locale);
    }

    private void addNameExact(String field, String localizedValue) {
        if (field.equals(NAME)) {
            this.nameExact.add(localizedValue);
        }
    }

    private void buildTenantField(String field) {
        if (StringUtils.isEmpty((String)this.document.getString(field))) {
            this.builtDocument.put(FieldNames.TENANT_ID.toString(), (Object)"publictenant");
        } else {
            this.builtDocument.put(FieldNames.TENANT_ID.toString(), (Object)this.document.getString(field));
        }
    }

    private void finishBuildingIndexFields() {
        String documentType = (String)this.document.get(FieldNames.TYPE.toString());
        if (CMFieldBuilder.isOutputType(documentType)) {
            this.builtDocument.put(FieldNames.CONTENT.toString(), (Object)"_NOT_PROCESSED_");
        }
        if (!this.document.containsKey((Object)FieldNames.HIDDEN.toString())) {
            this.builtDocument.put(FieldNames.HIDDEN.toString(), (Object)Boolean.toString(false));
        }
        this.updateNameExact();
    }

    private void updateNameExact() {
        if (this.nameExact.isEmpty()) {
            this.builtDocument.remove((Object)NAME_EXACT);
        } else {
            this.builtDocument.put(NAME_EXACT, (Object)new JsonArray(this.nameExact));
        }
    }
}

