/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.feature;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.smarts.schema.FeatureType;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Feature {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String featureKey;
    private String featureKeyLC;
    private String featureKeyTokenized;
    private String featureKeyLemma;
    private List<String> featureSynonyms;
    private List<String> searchableConcepts;
    private long creationDate = new Date().getTime();
    private long lastModifiedDate = new Date().getTime();
    private FeatureType featureType;
    private String featureTextInfo;
    private String columnInfo;
    private String columnInfoRef;
    private String idForExpression;
    private String datasetRef;
    private String smartsModuleRef;
    private String smartsModulePartRef;
    private String assetRef;
    private String userID;
    private String tenantID;

    public String getId() {
        return Feature.convertToHexStrings(this.getFeatureKey(), this.getSmartsModuleRef(), this.getTenantID(), this.getFeatureType(), this.getDatasetRef());
    }

    private static String convertToHexStrings(String ... fields) {
        StringBuilder featureIDBuilder = new StringBuilder();
        for (String field : fields) {
            if (!StringUtils.isNotEmpty((String)field)) continue;
            Feature.appendHashCodeAndPipeIfNeeded(featureIDBuilder, field);
        }
        return featureIDBuilder.toString();
    }

    private static void appendHashCodeAndPipeIfNeeded(StringBuilder featureIDBuilder, String value) {
        if (featureIDBuilder.length() > 0) {
            featureIDBuilder.append("|");
        }
        featureIDBuilder.append(Integer.toHexString(value.hashCode()));
    }

    public String getFeatureKey() {
        return this.featureKey;
    }

    public void setFeatureKey(String value) {
        this.featureKey = value;
    }

    public String getFeatureKeyLC() {
        return this.featureKeyLC;
    }

    public void setFeatureKeyLC(String value) {
        this.featureKeyLC = value;
    }

    public String getFeatureKeyTokenized() {
        return this.featureKeyTokenized;
    }

    public void setFeatureKeyTokenized(String value) {
        this.featureKeyTokenized = value;
    }

    public String getFeatureKeyLemma() {
        return this.featureKeyLemma;
    }

    public void setFeatureKeyLemma(String value) {
        this.featureKeyLemma = value;
    }

    public List<String> getFeatureSynonym() {
        if (this.featureSynonyms == null) {
            this.featureSynonyms = new ArrayList<String>();
        }
        return this.featureSynonyms;
    }

    public void setFeatureSynonyms(List<String> value) {
        this.featureSynonyms = value;
    }

    public List<String> getSearchableConcepts() {
        if (this.searchableConcepts == null) {
            this.searchableConcepts = new ArrayList<String>();
        }
        return this.searchableConcepts;
    }

    public void setSearchableConcepts(List<String> value) {
        this.searchableConcepts = value;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long value) {
        this.creationDate = value;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long value) {
        this.lastModifiedDate = value;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String value) {
        this.userID = value;
    }

    public String getFeatureType() {
        if (this.featureType != null) {
            return this.featureType.name();
        }
        return "";
    }

    public void setFeatureType(FeatureType value) {
        this.featureType = value;
    }

    public String getFeatureTextInfo() {
        return this.featureTextInfo;
    }

    public void setFeatureTextInfo(String value) {
        this.featureTextInfo = value;
    }

    public String getColumnInfo() {
        return this.columnInfo;
    }

    public void setColumnInfo(String value) {
        this.columnInfo = value;
    }

    public String getColumnInfoRef() {
        return this.columnInfoRef;
    }

    public void setColumnInfoRef(String value) {
        this.columnInfoRef = value;
    }

    public String getIdForExpression() {
        return this.idForExpression;
    }

    public void setIdForExpression(String value) {
        this.idForExpression = value;
    }

    public String getDatasetRef() {
        return this.datasetRef;
    }

    public void setDatasetRef(String value) {
        this.datasetRef = value;
    }

    public String getSmartsModuleRef() {
        return this.smartsModuleRef;
    }

    public String getSmartsModulePartRef() {
        return this.smartsModulePartRef;
    }

    public void setSmartsModuleRef(String value) {
        this.smartsModuleRef = value;
    }

    public void setSmartsModulePartRef(String value) {
        this.smartsModulePartRef = value;
    }

    public String getAssetRef() {
        return this.assetRef;
    }

    public void setAssetRef(String value) {
        this.assetRef = value;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public void setTenantID(String value) {
        this.tenantID = value;
    }

    public JsonObject toJsonObject() {
        JsonObject feature = new JsonObject();
        Feature.addRequiredJsonField(feature, "id", this.getId());
        Feature.addRequiredJsonField(feature, "featureKey", this.getFeatureKey());
        Feature.addRequiredJsonField(feature, "featureKeyLC", this.getFeatureKeyLC());
        Feature.addOptionalJsonField(feature, "featureKeyTokenized", this.getFeatureKeyTokenized());
        Feature.addOptionalJsonField(feature, "featureKeyLemma", this.getFeatureKeyLemma());
        Feature.addOptionalJsonFieldList(feature, "featureSynonyms", this.getFeatureSynonym());
        Feature.addOptionalJsonFieldList(feature, "searchableConcepts", this.getSearchableConcepts());
        Feature.addRequiredJsonField(feature, "creationDate", this.getCreationDate());
        Feature.addRequiredJsonField(feature, "lastModifiedDate", this.getLastModifiedDate());
        Feature.addRequiredJsonField(feature, "featureType", this.getFeatureType());
        Feature.addOptionalJsonField(feature, "featureTextInfo", this.getFeatureTextInfo());
        Feature.addOptionalJsonField(feature, "columnInfo", this.getColumnInfo());
        Feature.addOptionalJsonField(feature, "columnInfoRef", this.getColumnInfoRef());
        Feature.addOptionalJsonField(feature, "idForExpression", this.getIdForExpression());
        Feature.addOptionalJsonField(feature, "datasetRef", this.getDatasetRef());
        Feature.addRequiredJsonField(feature, "smartsModuleRef", this.getSmartsModuleRef());
        Feature.addRequiredJsonField(feature, "smartsModulePartRef", this.getSmartsModulePartRef());
        Feature.addRequiredJsonField(feature, "assetRef", this.getAssetRef());
        Feature.addOptionalJsonField(feature, "userID", this.getUserID());
        Feature.addRequiredJsonField(feature, "tenantID", this.getTenantID());
        return feature;
    }

    private static void addRequiredJsonField(JsonObject feature, String key, Object value) {
        if (value == null) {
            LOG.error("Feature extraction was incorrect, required field: {} was not set.", (Object)key);
            throw new SearchException(SearchMessageKeys.FIELD_NULL, key);
        }
        feature.put(key, value);
    }

    private static void addOptionalJsonField(JsonObject feature, String key, Object value) {
        if (value != null) {
            feature.put(key, value);
        }
    }

    private static void addOptionalJsonFieldList(JsonObject feature, String key, List<String> value) {
        if (CollectionUtils.isNotEmpty(value)) {
            feature.put(key, value);
        }
    }
}

