/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.feature;

import com.ibm.bi.search.indexing.solr.feature.Feature;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.schema.AnalysisPhase;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.schema.util.OntologyCommon;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SmartsModule smartsModule;
    private String tenantID;
    private String userID;
    private String parentID;
    private String assetRef;
    private String smartsModulePartID;
    private long hardCodedDate = new Date().getTime();

    public FeatureExtractor(SmartsModule smartsModule, String tenantID, String userID, String parentID, String assetRef, String smartsModulePartID) {
        this.smartsModule = smartsModule;
        this.tenantID = tenantID;
        this.userID = userID;
        this.parentID = parentID;
        this.assetRef = assetRef;
        this.smartsModulePartID = smartsModulePartID;
    }

    public List<Feature> extractFeatures() {
        if (this.smartsModule == null) {
            return Collections.emptyList();
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(this.createNameFeature());
        features.add(this.createDescriptionFeature());
        features.addAll(this.addDataSetFeatures());
        return FeatureExtractor.removeInvalidFeatures(features);
    }

    private Feature createNameFeature() {
        Feature nameFeature = this.createFeature(this.smartsModule.getName(), FeatureType.SMARTSMODULE_NAME);
        if (nameFeature != null && this.smartsModule.getLabel() != null) {
            FeatureExtractor.setFeatureTextInfo(nameFeature, this.smartsModule.getLabel());
        }
        return nameFeature;
    }

    private Feature createDescriptionFeature() {
        Feature descriptionFeature = this.createFeature(this.smartsModule.getDescription(), FeatureType.SMARTSMODULE_DESC);
        if (descriptionFeature != null && this.smartsModule.getDescriptionLabel() != null) {
            FeatureExtractor.setFeatureTextInfo(descriptionFeature, this.smartsModule.getDescriptionLabel());
        }
        return descriptionFeature;
    }

    private Feature createFeature(String featureKey, FeatureType featureType) {
        if (featureKey == null) {
            LOG.debug("Could not index feature of type:{} with smartsModulePartRef:{} and assetRef:{} because featureKey was null.", new Object[]{featureType, this.smartsModulePartID, this.assetRef});
            return null;
        }
        Feature feature = new Feature();
        feature.setSmartsModuleRef(this.parentID);
        feature.setSmartsModulePartRef(this.smartsModulePartID);
        feature.setAssetRef(this.assetRef);
        feature.setCreationDate(this.hardCodedDate);
        feature.setLastModifiedDate(this.hardCodedDate);
        feature.setFeatureKey(featureKey);
        feature.setFeatureType(featureType);
        feature.setFeatureKeyLC(featureKey.toLowerCase());
        feature.setTenantID(this.tenantID);
        if (StringUtils.isNotEmpty((String)this.userID)) {
            feature.setUserID(this.userID);
        }
        return feature;
    }

    private List<Feature> addDataSetFeatures() {
        ArrayList<Feature> dataSetFeatures = new ArrayList<Feature>();
        for (DatasetInfo dataSet : this.smartsModule.getDatasets()) {
            Feature dataSetFeature;
            if (dataSet == null || !FeatureExtractor.dataSetIsDoneAnalysisPhases(dataSet) || (dataSetFeature = this.createFeature(dataSet.getName(), FeatureType.DATASET_NAME)) == null) continue;
            dataSetFeature.setDatasetRef(dataSet.getId());
            FeatureExtractor.setFeatureLexicalInfo(dataSet.getLabel(), dataSetFeature);
            dataSetFeatures.add(dataSetFeature);
            dataSetFeatures.addAll(this.addColumnFeatures(dataSet));
        }
        return dataSetFeatures;
    }

    private static boolean dataSetIsDoneAnalysisPhases(DatasetInfo dataSet) {
        List analysisPhases = dataSet.getAnalysisPhases();
        if (CollectionUtils.isNotEmpty((Collection)analysisPhases)) {
            AnalysisPhase analysisPhase = (AnalysisPhase)analysisPhases.get(0);
            return analysisPhase.getAnalysisState() == AnalysisStateType.DONE;
        }
        return false;
    }

    private List<Feature> addColumnFeatures(DatasetInfo dataSet) {
        ArrayList<Feature> columnFeatures = new ArrayList<Feature>();
        for (ColumnInfo column : SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataSet)) {
            Feature columnFeature;
            if (column == null || (columnFeature = this.createFeature(column.getName(), FeatureType.COLUMN_NAME)) == null) continue;
            columnFeature.setDatasetRef(dataSet.getId());
            FeatureExtractor.setFeatureLexicalInfo(column.getLabel(), columnFeature);
            FeatureExtractor.setColumnFeatureSemanticInfo(column, columnFeature);
            FeatureExtractor.setColumnFeatureColumnInfo(column, columnFeature);
            columnFeatures.add(columnFeature);
        }
        return columnFeatures;
    }

    private static Feature setFeatureLexicalInfo(TextInfo label, Feature columnFeature) {
        if (label == null) {
            return columnFeature;
        }
        FeatureExtractor.setFeatureTextInfo(columnFeature, label);
        if (CollectionUtils.isEmpty((Collection)label.getPhrases())) {
            return columnFeature;
        }
        for (PhraseInfo phrase : label.getPhrases()) {
            if (phrase == null || CollectionUtils.isEmpty((Collection)phrase.getTokens())) continue;
            List tokens = phrase.getTokens();
            StringBuilder lemmaBuf = new StringBuilder();
            StringBuilder tokenizedBuf = new StringBuilder();
            for (int i = 0; i < tokens.size() - 1; ++i) {
                TokenInfo token = (TokenInfo)tokens.get(i);
                if (token == null) continue;
                lemmaBuf.append(token.getLemma() + " ");
                tokenizedBuf.append(token.getText() + " ");
            }
            TokenInfo lastToken = (TokenInfo)tokens.get(tokens.size() - 1);
            lemmaBuf.append(lastToken.getLemma());
            tokenizedBuf.append(lastToken.getText());
            columnFeature.setFeatureKeyLemma(lemmaBuf.toString());
            columnFeature.setFeatureKeyTokenized(tokenizedBuf.toString());
        }
        return columnFeature;
    }

    private static Feature setColumnFeatureSemanticInfo(ColumnInfo column, Feature columnFeature) {
        List concepts;
        SemanticInfo semanticInfo = column.getSemanticInfo();
        if (semanticInfo != null && (concepts = semanticInfo.getConcepts()) != null) {
            FeatureExtractor.addConcepts(ConceptsRegistry.instance().getConcepts(concepts.stream().map(ConceptInfo::getConceptID).collect(Collectors.toList())), columnFeature);
        }
        return columnFeature;
    }

    private static Feature setColumnFeatureColumnInfo(ColumnInfo column, Feature columnFeature) {
        column.getSamples().clear();
        column.getSampleDistinctValues().clear();
        column.getSampleDistinctValueCounts().clear();
        try {
            columnFeature.setColumnInfoRef(column.getId());
            columnFeature.setIdForExpression(column.getIdForExpression());
            columnFeature.setColumnInfo(JAXBHelper.marshalToJSON((Object)column));
        }
        catch (IOException e) {
            LOG.error("Could not marshal columnInfo.", (Throwable)e);
        }
        return columnFeature;
    }

    private static void addConcepts(List<Concept> concepts, Feature columnFeature) {
        Set<Concept> conceptsAndAncestors = FeatureExtractor.getConceptsAndAncestors(concepts);
        columnFeature.getSearchableConcepts().addAll(FeatureExtractor.getFilteredConcepts(conceptsAndAncestors, columnFeature));
    }

    private static Set<Concept> getConceptsAndAncestors(List<Concept> concepts) {
        Set<Concept> conceptsAndAncestors = concepts.stream().flatMap(c -> c.getAncestors().stream()).collect(Collectors.toSet());
        conceptsAndAncestors.addAll(concepts);
        return conceptsAndAncestors;
    }

    private static List<String> getFilteredConcepts(Set<Concept> conceptsAndAncestors, Feature columnFeature) {
        return conceptsAndAncestors.stream().filter(concept -> concept.getIRI().contains("/common#")).map(Concept::getName).filter(cName -> !OntologyCommon.getUnsearcableConceptShortNames().contains(cName) && !columnFeature.getSearchableConcepts().contains(cName)).collect(Collectors.toList());
    }

    private static void setFeatureTextInfo(Feature feature, TextInfo label) {
        try {
            feature.setFeatureTextInfo(JAXBHelper.marshalToJSON((Object)label));
        }
        catch (IOException e) {
            LOG.warn("Could not marshal smartsModule label.", (Throwable)e);
        }
    }

    private static List<Feature> removeInvalidFeatures(List<Feature> features) {
        features.removeIf(Objects::isNull);
        return features;
    }
}

