/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.feature;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.constants.ObjectTypes;
import com.ibm.bi.search.handlers.indices.IIndicesController;
import com.ibm.bi.search.indexing.solr.CollectionCreator;
import com.ibm.bi.search.indexing.solr.SolrHandlerFactory;
import com.ibm.bi.search.indexing.solr.feature.SmartsFeatureExt;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsFeatureController
implements IIndicesController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String UNSUPPORTED_MESSAGE = "The %s collection does not support this operation";
    private final SolrHandlerFactory solrFactory;
    private final SmartsFeatureExt featureExt;
    private final CollectionCreator creator;

    public SmartsFeatureController() {
        this(new SolrHandlerFactory(), new SmartsFeatureExt(), new CollectionCreator());
    }

    public SmartsFeatureController(SolrHandlerFactory solrFactory, SmartsFeatureExt featureExt, CollectionCreator creator) {
        this.solrFactory = solrFactory;
        this.featureExt = featureExt;
        this.creator = creator;
    }

    private boolean smartsFeatureExists() {
        return this.solrFactory.createSolrHandler().getCores().contains(IndexNames.SMARTS_FEATURE.toString());
    }

    @Override
    public void createIndex(JsonObject schema) {
        if (!this.smartsFeatureExists()) {
            this.creator.createSmartsFeatureCollection();
        }
    }

    @Override
    public void addDocuments(String indexId, JsonArray documents) {
        this.updateDocuments(indexId, documents);
    }

    @Override
    public void updateDocuments(String indexId, JsonArray documents) {
        JsonArray smartsModules = SmartsFeatureController.getSmartsModuleDocuments(documents);
        try {
            this.featureExt.indexSmartsModuleFeatures(smartsModules);
        }
        catch (IOException e) {
            LOG.error("Could not unmarshal smartModule object.", (Throwable)e);
        }
    }

    private static JsonArray getSmartsModuleDocuments(JsonArray documents) {
        JsonArray documentsArray = new JsonArray();
        for (Object o : documents) {
            JsonObject document = (JsonObject)o;
            if (!SmartsFeatureController.isDocumentSmartsModule(document)) continue;
            documentsArray.addItem((Object)document);
        }
        return documentsArray;
    }

    private static boolean isDocumentSmartsModule(JsonObject document) {
        return ObjectTypes.SMARTS_MODULE.toString().equals(document.getString(FieldNames.TYPE.toString())) && document.getString(FieldNames.CONTENT.toString()) != null;
    }

    @Override
    public void deleteDocument(String indexId, String objectId) {
        this.deleteDocuments(indexId, new JsonArray(new Object[]{objectId}));
    }

    @Override
    public void deleteDocuments(String indexId, JsonArray objectIds) {
        for (Object o : objectIds) {
            String objectId = (String)o;
            this.solrFactory.createSolrHandler().deleteDocumentsByQuery(IndexNames.SMARTS_FEATURE.toString(), SmartsFeatureController.getAllSmartsModulesFromCMId(objectId));
        }
    }

    private static String getAllSmartsModulesFromCMId(String cmId) {
        return String.format("%s:%s", FieldNames.SMARTS_MODULE_PART_REF.toString(), cmId);
    }

    @Override
    public void deleteIndex(String indexId) {
        if (this.smartsFeatureExists()) {
            this.solrFactory.createSolrHandler().deleteCore(indexId);
        }
    }

    @Override
    public JsonObject getIndex(String indexId) {
        throw new UnsupportedOperationException(String.format(UNSUPPORTED_MESSAGE, IndexNames.SMARTS_FEATURE.toString()));
    }

    @Override
    public JsonObject getAllIndices() {
        throw new UnsupportedOperationException(String.format(UNSUPPORTED_MESSAGE, IndexNames.SMARTS_FEATURE.toString()));
    }

    @Override
    public void updatePermissions(String indexId, JsonArray permissions) {
        throw new UnsupportedOperationException(String.format(UNSUPPORTED_MESSAGE, IndexNames.SMARTS_FEATURE.toString()));
    }
}

